% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/axis-utils_wlength.R
\name{scale_x_wl_continuous}
\alias{scale_x_wl_continuous}
\title{Wavelength x-scale}
\usage{
scale_x_wl_continuous(unit.exponent = -9,
  name = w_length_label(unit.exponent = unit.exponent),
  breaks = scales::pretty_breaks(n = 7), labels = SI_pl_format(exponent =
  unit.exponent + 9), ...)
}
\arguments{
\item{unit.exponent}{integer}

\item{name}{The name of the scale, used for the axis-label.}

\item{breaks}{The positions of ticks or a function to generate them.}

\item{labels}{The tick labels or a function to generate them from the tick
positions.}

\item{...}{other named arguments passed to \code{scale_y_continuous}}
}
\description{
Scale x continuous with defaults suitable for wavelengths in nanometres.
}
\note{
This function only alters two default arguments, please, see
documentation for \code{\link[ggplot2]{scale_x_continuous}}
}
\examples{
library(ggplot2)
library(photobiology)

ggplot(sun.spct) +
  geom_line() +
  scale_x_wl_continuous()

ggplot(sun.spct) +
  geom_line() +
  scale_x_wl_continuous(-6)

ggplot(sun.spct) +
  geom_line() +
  scale_x_wl_continuous(sec.axis = sec_axis_w_number())

ggplot(sun.spct) +
  geom_line() +
  scale_x_wl_continuous(unit.exponent = -6,
                        sec.axis = sec_axis_w_number())

}
