% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/axis-utils-response-spct.R
\name{scale_y_s.e.response_continuous}
\alias{scale_y_s.e.response_continuous}
\alias{scale_y_s.q.response_continuous}
\title{Spectral response y-scale}
\usage{
scale_y_s.e.response_continuous(unit.exponent = 0,
  name = s.e.response_label(unit.exponent),
  labels = SI_pl_format(exponent = -unit.exponent), ...)

scale_y_s.q.response_continuous(unit.exponent = 0,
  name = s.q.response_label(unit.exponent = unit.exponent),
  labels = SI_pl_format(exponent = -unit.exponent), ...)
}
\arguments{
\item{unit.exponent}{integer}

\item{name}{The name of the scale, used for the axis-label.}

\item{labels}{The tick labels or a function to generate them.}

\item{...}{other named arguments passed to \code{scale_y_continuous}}
}
\description{
Scale y continuous with defaults suitable for raw detector counts.
}
\note{
This function only alters two default arguments, please, see
documentation for \code{\link[ggplot2]{scale_continuous}}
}
\examples{

ggplot(ccd.spct) +
  geom_line() +
  scale_y_s.e.response_continuous(unit.exponent = 6) +
  scale_x_wl_continuous()

ggplot(ccd.spct, unit.out = "photon") +
  geom_line() +
  scale_y_s.q.response_continuous() +
  scale_x_wl_continuous()

}
