% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stat-spikes.R
\name{stat_spikes}
\alias{stat_spikes}
\title{Find spikes}
\usage{
stat_spikes(
  mapping = NULL,
  data = NULL,
  geom = "point",
  position = "identity",
  ...,
  z.threshold = 9,
  max.spike.width = 8,
  chroma.type = "CMF",
  label.fmt = "\%.3g",
  x.label.fmt = label.fmt,
  y.label.fmt = label.fmt,
  na.rm = FALSE,
  show.legend = FALSE,
  inherit.aes = TRUE
)
}
\arguments{
\item{mapping}{The aesthetic mapping, usually constructed with
\code{\link[ggplot2]{aes}} or \code{\link[ggplot2]{aes_}}. Only needs to be set
at the layer level if you are overriding the plot defaults.}

\item{data}{A layer specific dataset - only needed if you want to override
the plot defaults.}

\item{geom}{The geometric object to use display the data}

\item{position}{The position adjustment to use for overlapping points
on this layer}

\item{...}{other arguments passed on to \code{\link[ggplot2]{layer}}. This can
include aesthetics whose values you want to set, not map. See
\code{\link[ggplot2]{layer}} for more details.}

\item{z.threshold}{numeric Modified Z values larger than \code{z.threshold}
are considered to be spikes.}

\item{max.spike.width}{integer Wider regions with high Z values are not detected as
spikes.}

\item{chroma.type}{character one of "CMF" (color matching function) or "CC"
(color coordinates) or a \code{\link[photobiology]{chroma_spct}} object.}

\item{label.fmt}{character  string giving a format definition for converting
values into character strings by means of function \code{\link{sprintf}}.}

\item{x.label.fmt}{character  string giving a format definition for converting
$x$-values into character strings by means of function \code{\link{sprintf}}.}

\item{y.label.fmt}{character  string giving a format definition for converting
$y$-values into character strings by means of function \code{\link{sprintf}}.}

\item{na.rm}{a logical value indicating whether NA values should be
stripped before the computation proceeds.}

\item{show.legend}{logical. Should this layer be included in the legends?
\code{NA}, the default, includes if any aesthetics are mapped.
\code{FALSE} never includes, and \code{TRUE} always includes.}

\item{inherit.aes}{If \code{FALSE}, overrides the default aesthetics,
rather than combining with them. This is most useful for helper functions
that define both data and aesthetics and shouldn't inherit behaviour from
the default plot specification, e.g. \code{\link[ggplot2]{borders}}.}
}
\value{
A data frame with one row for each peak (or valley) found in the
  data.
}
\description{
\code{stat_spikes} finds at which x positions spikes are located. Spikes
can be either upwards or downwards from the baseline.
}
\details{
This stat uses \code{geom_point} by default as it is the geom most
  likely to work well in almost any situation without need of tweaking. The
  default aesthetics set by this stat allows its direct use with
  \code{geom_text}, \code{geom_label}, \code{geom_line}, \code{geom_rug},
  \code{geom_hline} and \code{geom_vline}. The formatting of the labels
  returned can be controlled by the user.
}
\note{
This stat works nicely together with geoms
  \code{geom_text_repel} and
  \code{geom_label_repel} from package
  \code{\link[ggrepel]{ggrepel}} to solve the problem of overlapping labels
  by displacing them. To discard overlapping labels use \code{check_overlap =
  TRUE} as argument to \code{geom_text}.
 By default the labels are character values suitable to be plotted as is, but
 with a suitable \code{label.fmt} labels suitable for parsing by the geoms
 (e.g. into expressions containing greek letters or super or subscripts) can
 be also easily obtained.
}
\section{Computed variables}{

\describe{
  \item{x}{x-value at the peak (or valley) as numeric}
  \item{y}{y-value at the peak (or valley) as numeric}
  \item{x.label}{x-value at the peak (or valley) formatted as character}
  \item{y.label}{y-value at the peak (or valley) formatted as character}
  \item{wl.color}{color definition calculated by assuming that x-values are
  wavelengths expressed in nanometres.}
  \item{BW.color}{color definition that either "black" or "white", to ensure
  high contrast to \code{wl.color}.}
}
}

\section{Default aesthetics}{

Set by the statistic and available to geoms.
\describe{
  \item{label}{stat(x.label)}
  \item{xintercept}{stat(x)}
  \item{yintercept}{stat(y)}
  \item{fill}{stat(wl.color)}
}
}

\section{Required aesthetics}{

Required by the statistic and need to be set with \code{aes()}.
\describe{
  \item{x}{numeric, wavelength in nanometres}
  \item{y}{numeric, a spectral quantity}
}
}

\examples{

# ggplot() methods for spectral objects set a default mapping for x and y.

# two spurious(?) spikes
ggplot(sun.spct) +
  geom_line() +
  stat_spikes(colour = "red", alpha = 0.3)

# no spikes detected
ggplot(sun.spct) +
  geom_line() +
  stat_spikes(colour = "red", alpha = 0.3,
              max.spike.width = 3,
              z.threshold = 12)

# small noise spikes detected
ggplot(white_led.raw_spct) +
  geom_line() +
  stat_spikes(colour = "red", alpha = 0.3)

ggplot(white_led.raw_spct) +
  geom_line() +
  stat_spikes(colour = "red", alpha = 0.3) +
  stat_spikes(geom = "text", colour = "red", check_overlap = TRUE,
             vjust = -0.5, label.fmt = "\%3.0f nm")

ggplot(white_led.raw_spct, aes(w.length, counts_2)) +
  geom_line() +
  stat_spikes(colour = "red", alpha = 0.3,
              max.spike.width = 3,
              z.threshold = 12)

}
\seealso{
\code{\link[photobiology]{find_spikes}}, which is used internally,
  for a description of the algorithm used.

Other stats functions: 
\code{\link{stat_color}()},
\code{\link{stat_find_qtys}()},
\code{\link{stat_find_wls}()},
\code{\link{stat_label_peaks}()},
\code{\link{stat_peaks}()},
\code{\link{stat_wb_box}()},
\code{\link{stat_wb_column}()},
\code{\link{stat_wb_contribution}()},
\code{\link{stat_wb_hbar}()},
\code{\link{stat_wb_irrad}()},
\code{\link{stat_wb_label}()},
\code{\link{stat_wb_mean}()},
\code{\link{stat_wb_relative}()},
\code{\link{stat_wb_sirrad}()},
\code{\link{stat_wb_total}()},
\code{\link{stat_wl_strip}()},
\code{\link{stat_wl_summary}()}
}
\concept{stats functions}
