% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geom_epicurve.R
\docType{data}
\name{geom_epicurve}
\alias{geom_epicurve}
\alias{stat_bin_date}
\alias{stat_date_count}
\alias{StatEpicurve}
\alias{StatBinDate}
\alias{StatDateCount}
\alias{geom_epicurve_text}
\alias{geom_epicurve_point}
\title{Create an epidemic curve plot or bin/count observations by date periods}
\usage{
geom_epicurve(
  mapping = NULL,
  data = NULL,
  stat = "epicurve",
  position = "stack",
  date_resolution = NULL,
  week_start = getOption("lubridate.week.start", 1),
  width = NULL,
  relative.width = 1,
  ...,
  na.rm = FALSE,
  show.legend = NA,
  inherit.aes = TRUE
)

stat_bin_date(
  mapping = NULL,
  data = NULL,
  geom = "line",
  position = "identity",
  date_resolution = NULL,
  week_start = getOption("lubridate.week.start", 1),
  fill_gaps = FALSE,
  ...,
  na.rm = FALSE,
  show.legend = NA,
  inherit.aes = TRUE
)

stat_date_count(
  mapping = NULL,
  data = NULL,
  geom = "line",
  position = "identity",
  date_resolution = NULL,
  week_start = getOption("lubridate.week.start", 1),
  fill_gaps = FALSE,
  ...,
  na.rm = FALSE,
  show.legend = NA,
  inherit.aes = TRUE
)

geom_epicurve_text(
  mapping = NULL,
  data = NULL,
  stat = "epicurve",
  vjust = 0.5,
  date_resolution = NULL,
  week_start = getOption("lubridate.week.start", 1),
  ...,
  na.rm = FALSE,
  show.legend = NA,
  inherit.aes = TRUE
)

geom_epicurve_point(
  mapping = NULL,
  data = NULL,
  stat = "epicurve",
  vjust = 0.5,
  date_resolution = NULL,
  week_start = getOption("lubridate.week.start", 1),
  ...,
  na.rm = FALSE,
  show.legend = NA,
  inherit.aes = TRUE
)
}
\arguments{
\item{mapping}{Set of aesthetic mappings created by \code{\link[ggplot2]{aes}}. Commonly used mappings:
\itemize{
\item \strong{x or y}: date or datetime. Numeric is technically supported.
\item \strong{fill}: for colouring groups.
\item \strong{weight}: if data is already aggregated (e.g., case counts).
}}

\item{data}{The data frame containing the variables for the plot}

\item{stat}{For the geoms, use "\code{epicurve}" (default) to outline individual cases, or "\code{bin_date}" to aggregate data by group.
For large datasets, "\code{bin_date}" is recommended for better performance by drawing less rectangles.}

\item{position}{Position adjustment. Currently supports "\code{stack}" for \code{geom_epicurve()}.}

\item{date_resolution}{Character string specifying the time unit for date aggregation. If \code{NULL} (default),
no date binning is performed. Possible values include: \code{"hour"}, \code{"day"}, \code{"week"}, \code{"month"}, \code{"bimonth"}, \code{"season"},
\code{"quarter"}, \code{"halfyear"}, \code{"year"}. Special values:
\itemize{
\item \code{"isoweek"}: ISO week standard (week starts Monday, \code{week_start = 1})
\item \code{"epiweek"}: US CDC epiweek standard (week starts Sunday, \code{week_start = 7})
\item \code{"isoyear"}: ISO year (corresponding year of the ISO week, differs from year by 1-3 days)
\item \code{"epiyear"}: Epidemiological year (corresponding year of the epiweek, differs from year by 1-3 days)
Defaults to \code{NULL}, i.e. no binning.
}}

\item{week_start}{Integer specifying the start of the week (1 = Monday, 7 = Sunday).
Only used when \code{date_resolution} involves weeks. Defaults to 1 (Monday).
Overridden by \code{"isoweek"} (1) and \code{"epiweek"} (7) settings.}

\item{width}{Numeric value specifying the width of the bars. If \code{NULL}, calculated
based on \code{date_resolution} and \code{relative.width}.}

\item{relative.width}{Numeric value between 0 and 1 adjusting the relative width
of bars. Defaults to 1}

\item{...}{Other arguments passed to \code{\link[ggplot2]{layer}}. For example:
\itemize{
\item \strong{colour}: Colour of the outlines around cases. Disable with \code{colour = NA}. Defaults to \code{"white"}.
\item \strong{linewidth}:  Width of the case outlines.
}

For \code{geom_epicurve_text()} additional \code{\link[ggplot2]{geom_text}} arguments are supported:
\itemize{
\item \strong{fontface}: Font face for text labels: one of "plain", "bold", "italic", "bold.italic".
\item \strong{family}: The font family.
\item \strong{size}: The font size.
}}

\item{na.rm}{If \code{FALSE}, the default, missing values are removed with
a warning. If \code{TRUE}, missing values are silently removed.}

\item{show.legend}{logical. Should this layer be included in the legends?
\code{NA}, the default, includes if any aesthetics are mapped.
\code{FALSE} never includes, and \code{TRUE} always includes.
It can also be a named logical vector to finely select the aesthetics to
display.}

\item{inherit.aes}{If \code{FALSE}, overrides the default aesthetics,
rather than combining with them. This is most useful for helper functions
that define both data and aesthetics and shouldn't inherit behaviour from
the default plot specification, e.g. \code{\link[ggplot2:borders]{borders()}}.}

\item{geom}{The geometric object to use to display the data for this layer.
When using a \verb{stat_*()} function to construct a layer, the \code{geom} argument
can be used to override the default coupling between stats and geoms.}

\item{fill_gaps}{Logical; If \code{TRUE}, gaps in the time series will be filled with a count of 0. Often needed for line charts.}

\item{vjust}{Vertical justification of the text or shape. Value between 0 and 1.
Used by \code{geom_epicurve_text} and \code{geom_epicurve_point} to control
vertical positioning within the case rectangles. Defaults to 0.5 (center).}
}
\value{
A \code{ggplot2} geom layer that can be added to a plot
}
\description{
Creates a epicurve plot for visualizing epidemic case counts in outbreaks (epidemiological curves).
An epicurve is a bar plot, where every case is outlined. \code{geom_epicurve} additionally provides
date-based aggregation of cases (e.g. per week or month and many more) using \link{bin_by_date}.
\itemize{
\item For week aggregation both isoweek (World + ECDC) and epiweek (US CDC) are supported.
\item \code{stat_bin_date} and its alias \code{stat_date_count} provide date based binning only. After binning the by date with \link{bin_by_date}, these
stats behave like \link[ggplot2:geom_bar]{ggplot2::stat_count}.
\item \code{geom_epicurve_text} adds text labels to cases on epicurve plots.
\item \code{geom_epicurve_point} adds points/shapes to cases on epicurve plots.
}
}
\details{
Epi Curves are a public health tool for outbreak investigation. For more details see the references.
}
\examples{
# Basic epicurve with dates
library(ggplot2)
set.seed(1)

plot_data_epicurve_imp <- data.frame(
  date = rep(as.Date("2023-12-01") + ((0:300) * 1), times = rpois(301, 0.5))
)

ggplot(plot_data_epicurve_imp, aes(x = date, weight = 2)) +
  geom_vline_year(break_type = "week") +
  geom_epicurve(date_resolution = "week") +
  labs(title = "Epicurve Example") +
  scale_y_cases_5er() +
  # Correct ISOWeek labels for week-year
  scale_x_date(date_breaks = "4 weeks", date_labels = "W\%V'\%g") + 
  coord_equal(ratio = 7) + # Use coord_equal for square boxes. 'ratio' are the days per week.
  theme_bw()

# Categorical epicurve
library(tidyr)
library(outbreaks)

sars_canada_2003 |> # SARS dataset from outbreaks
  pivot_longer(starts_with("cases"), names_prefix = "cases_", names_to = "origin") |>
  ggplot(aes(x = date, weight = value, fill = origin)) +
  geom_epicurve(date_resolution = "week") +
  scale_x_date(date_labels = "W\%V'\%g", date_breaks = "2 weeks") +
  scale_y_cases_5er() +
  theme_classic()
}
\references{
\itemize{
\item Centers for Disease Control and Prevention. Quick-Learn Lesson:
Using an Epi Curve to Determine Mode of Spread. USA. \url{https://www.cdc.gov/training/quicklearns/epimode/}
\item Dicker, Richard C., Fátima Coronado, Denise Koo, and R. Gibson Parrish. 2006.
Principles of Epidemiology in Public Health Practice; an Introduction to Applied Epidemiology and Biostatistics.
3rd ed. USA. \url{https://stacks.cdc.gov/view/cdc/6914}
}
}
\seealso{
\code{\link[=scale_y_cases_5er]{scale_y_cases_5er()}}, \code{\link[=geom_vline_year]{geom_vline_year()}}
}
\keyword{datasets}
