% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/doc-data.R
\docType{data}
\name{data_USDA}
\alias{data_USDA}
\alias{USDA}
\title{USDA Textural Classification Data}
\format{1row per point, many points per classification representing the extremes of the area.}
\source{
Soil Mechanics Level 1, Module 3, USDA Textural Classification Study Guide
}
\usage{
data(USDA)
}
\description{
This dataset was issued by the United States Department of Agriculture (USDA) 
in the form of a ternary diagram, this original ternary diagram has been converted to numerical data 
and included here.
}
\examples{
#Load the Libraries
library(ggtern)
library(plyr)

#Load the Data.
data(USDA)

#Put tile labels at the midpoint of each tile.
USDA.LAB <- ddply(USDA,"Label",function(df){
  apply(df[,1:3],2,mean)
})

#Tweak
USDA.LAB$Angle = sapply(as.character(USDA.LAB$Label),function(x){
    switch(x,"Loamy Sand"=-35,0)
})

#Construct the plot.
ggtern(data=USDA,aes(Sand,Clay,Silt,color=Label,fill=Label)) +
  geom_polygon(alpha=0.75,size=0.5,color="black") +
  geom_mask() +  
  geom_text(data=USDA.LAB,aes(label=Label,angle=Angle),color="black",size=3.5) +
  theme_rgbw() + 
  theme_showsecondary() +
  theme_showarrows() +
  weight_percent() + 
  guides(fill='none') + 
  theme_legend_position("topleft") + 
  labs(title = "USDA Textural Classification Chart",
       fill  = "Textural Class",
       color = "Textural Class")
}
\seealso{
\link[=data]{ggtern datasets}
}
\author{
United States Department of Agriculture (USDA)

Nicholas Hamilton
}
