% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geom-Xisoprop.R
\docType{data}
\name{geom_Xisoprop}
\alias{geom_Xisoprop}
\alias{geom_Tisoprop}
\alias{GeomTisoprop}
\alias{geom_Lisoprop}
\alias{GeomLisoprop}
\alias{geom_Risoprop}
\alias{GeomRisoprop}
\title{Fixed Value Isoproportion Lines}
\usage{
geom_Tisoprop(mapping = NULL, data = NULL, ..., value, na.rm = FALSE,
  show.legend = NA)

geom_Lisoprop(mapping = NULL, data = NULL, ..., value, na.rm = FALSE,
  show.legend = NA)

geom_Risoprop(mapping = NULL, data = NULL, ..., value, na.rm = FALSE,
  show.legend = NA)
}
\arguments{
\item{mapping}{Set of aesthetic mappings created by \code{\link[=aes]{aes()}} or
\code{\link[=aes_]{aes_()}}. If specified and \code{inherit.aes = TRUE} (the
default), it is combined with the default mapping at the top level of the
plot. You must supply \code{mapping} if there is no plot mapping.}

\item{data}{The data to be displayed in this layer. There are three
options:

If \code{NULL}, the default, the data is inherited from the plot
data as specified in the call to \code{\link[=ggplot]{ggplot()}}.

A \code{data.frame}, or other object, will override the plot
data. All objects will be fortified to produce a data frame. See
\code{\link[=fortify]{fortify()}} for which variables will be created.

A \code{function} will be called with a single argument,
the plot data. The return value must be a \code{data.frame.}, and
will be used as the layer data.}

\item{...}{Other arguments passed on to \code{\link[=layer]{layer()}}. These are
often aesthetics, used to set an aesthetic to a fixed value, like
\code{color = "red"} or \code{size = 3}. They may also be parameters
to the paired geom/stat.}

\item{value, }{the isoproportion ratio to draw}

\item{na.rm}{If \code{FALSE}, the default, missing values are removed with
a warning. If \code{TRUE}, missing values are silently removed.}

\item{show.legend}{logical. Should this layer be included in the legends?
\code{NA}, the default, includes if any aesthetics are mapped.
\code{FALSE} never includes, and \code{TRUE} always includes.
It can also be a named logical vector to finely select the aesthetics to
display.}
}
\description{
Create fixed isoproportion lines for each of the ternary axes, \code{geom_Xisoprop(...), (X = T, L, R)} will draw an isoproportion
line projecting from the T, L and R apex respectively.
}
\section{Aesthetics}{

\Sexpr[results=rd,stage=build]{ggtern:::rd_aesthetics("geom", "Tisoprop")}
}

\examples{
data(Feldspar)
ggtern(data=Feldspar,aes(Ab,An,Or)) +
geom_Tisoprop(value=0.5) +
geom_Lisoprop(value=0.5) +
geom_Risoprop(value=0.5) +
geom_point()
}
\author{
Nicholas Hamilton
}
\keyword{datasets}
