% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geom-mean-ellipse.R, R/stat-mean-ellipse.R
\docType{data}
\name{geom_mean_ellipse}
\alias{geom_mean_ellipse}
\alias{stat_mean_ellipse}
\alias{StatMeanEllipse}
\title{Mean Ellipse}
\usage{
geom_mean_ellipse(
  mapping = NULL,
  data = NULL,
  stat = "MeanEllipse",
  position = "identity",
  ...,
  lineend = "butt",
  linejoin = "round",
  linemitre = 1,
  na.rm = FALSE,
  show.legend = NA,
  inherit.aes = TRUE
)

stat_mean_ellipse(
  mapping = NULL,
  data = NULL,
  geom = "MeanEllipse",
  position = "identity",
  ...,
  steps = 72,
  r = 1,
  na.rm = FALSE,
  show.legend = NA,
  inherit.aes = TRUE
)
}
\arguments{
\item{mapping}{Set of aesthetic mappings created by \code{\link[ggplot2:aes]{aes()}}. If specified and
\code{inherit.aes = TRUE} (the default), it is combined with the default mapping
at the top level of the plot. You must supply \code{mapping} if there is no plot
mapping.}

\item{data}{The data to be displayed in this layer. There are three
options:

If \code{NULL}, the default, the data is inherited from the plot
data as specified in the call to \code{\link[ggplot2:ggplot]{ggplot()}}.

A \code{data.frame}, or other object, will override the plot
data. All objects will be fortified to produce a data frame. See
\code{\link[ggplot2:fortify]{fortify()}} for which variables will be created.

A \code{function} will be called with a single argument,
the plot data. The return value must be a \code{data.frame}, and
will be used as the layer data. A \code{function} can be created
from a \code{formula} (e.g. \code{~ head(.x, 10)}).}

\item{position}{Position adjustment, either as a string naming the adjustment
(e.g. \code{"jitter"} to use \code{position_jitter}), or the result of a call to a
position adjustment function. Use the latter if you need to change the
settings of the adjustment.}

\item{...}{Other arguments passed on to \code{\link[ggplot2:layer]{layer()}}. These are
often aesthetics, used to set an aesthetic to a fixed value, like
\code{colour = "red"} or \code{size = 3}. They may also be parameters
to the paired geom/stat.}

\item{lineend}{Line end style (round, butt, square).}

\item{linejoin}{Line join style (round, mitre, bevel).}

\item{linemitre}{Line mitre limit (number greater than 1).}

\item{na.rm}{If \code{FALSE}, the default, missing values are removed with
a warning. If \code{TRUE}, missing values are silently removed.}

\item{show.legend}{logical. Should this layer be included in the legends?
\code{NA}, the default, includes if any aesthetics are mapped.
\code{FALSE} never includes, and \code{TRUE} always includes.
It can also be a named logical vector to finely select the aesthetics to
display.}

\item{inherit.aes}{If \code{FALSE}, overrides the default aesthetics,
rather than combining with them. This is most useful for helper functions
that define both data and aesthetics and shouldn't inherit behaviour from
the default plot specification, e.g. \code{\link[ggplot2:borders]{borders()}}.}

\item{geom, stat}{Use to override the default connection between
\code{geom_smooth()} and \code{stat_smooth()}.}

\item{steps}{the number of discretisation points to draw the ellipses}

\item{r}{a scaling of the half-diameters}
}
\description{
Produce ellipses from a mean and a variance of ternary compositional data, based off the function 
included in the \code{\link{compositions}} package.
}
\section{Aesthetics}{

\Sexpr[results=rd,stage=build]{ggtern:::rd_aesthetics("geom", "MeanEllipse")}
}

\section{Computed variables}{
 
Same as \code{\link{stat_contour}}
}

\examples{
  data(Feldspar)
  ggtern(data=Feldspar,aes(An,Ab,Or)) + 
    geom_point() + 
    geom_mean_ellipse()
data(Feldspar)
ggtern(data=Feldspar,aes(Ab,An,Or)) +
  theme_bw() + 
  stat_mean_ellipse(geom='polygon',steps=500,fill='red',color='black') +
  geom_point()
}
\author{
Nicholas Hamilton & Ashton Drew
}
\keyword{datasets}
