% Generated by roxygen2 (4.0.2): do not edit by hand
\name{print.ggvis}
\alias{print.ggvis}
\alias{view_dynamic}
\alias{view_static}
\title{View in a ggvis plot in the browser.}
\usage{
\method{print}{ggvis}(x, dynamic = NA, launch = interactive(), ...)

view_static(x, plot_id = rand_id("plot_"), dest = tempfile(pattern =
  "ggvis"))

view_dynamic(x, plot_id = rand_id("plot_"), port = NULL, quiet = FALSE)
}
\arguments{
\item{x}{A ggvis object.}

\item{dynamic}{Uses \code{view_dynamic} if \code{TRUE}, \code{view_static} if
\code{FALSE}. The default, \code{NA}, chooses automatically based on the
presence of reactives or interactive inputs in \code{x}.}

\item{launch}{If \code{TRUE}, will launch plot in a viewer/browser. If
\code{FALSE} returns an object that you can \code{print()} to launch.}

\item{...}{Other arguments passed on to \code{view_dynamic} and
\code{view_static} ?from \code{print}.}

\item{plot_id}{Unique identifier used to identify the plot on the page.}

\item{dest}{Directory in which to save html and depedencies. Created if
it doesn't already exist.}

\item{port}{the port on which to start the shiny app. If NULL (the default),
Shiny will select a random port.}

\item{quiet}{If \code{TRUE} show status messages from Shiny. (Default is
\code{FALSE}.)}
}
\description{
\code{view_static} creates a static web page in a temporary directory;
\code{view_dynamic} generate a dynamic shiny app and launches it.
\code{print} automatically picks between the two.
}
\keyword{internal}

