% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/org.R, R/org_exists.R, R/org_repo_search.R,
%   R/org_repo_stats.R, R/org_repos.R, R/org_team_details.R, R/org_teams.R
\name{org_details}
\alias{org_details}
\alias{org_exists}
\alias{org_repo_search}
\alias{org_repo_stats}
\alias{org_repos}
\alias{org_team_details}
\alias{org_teams}
\title{Obtain details on an organization's repos and teams}
\usage{
org_exists(org)

org_repo_search(org, name, extra = "", full_repo = TRUE)

org_repo_stats(
  org,
  branch = NULL,
  filter = "",
  filter_type = "in:name",
  inc_commits = TRUE,
  inc_issues = TRUE,
  inc_prs = TRUE
)

org_repos(org, filter = NULL, exclude = FALSE, full_repo = TRUE)

org_team_details(org)

org_teams(org, filter = NULL, exclude = FALSE, team_type = c("name", "slug"))
}
\arguments{
\item{org}{Character. Name of the GitHub organization(s).}

\item{name}{Character. Full or partial repo name to search for within the org}

\item{extra}{Character. Any additional search qualifiers, see
\href{https://docs.github.com/en/free-pro-team@latest/github/searching-for-information-on-github/searching-for-repositories}{Searching for repositories}
for details.}

\item{full_repo}{Logical. Should the full repository address be returned (e.g. \code{owner/repo} instead of just \code{repo})?}

\item{branch}{Character. The branch to use for counting commits, if \code{NULL} then each repo's default branch is used.}

\item{filter}{Character. Regular expression pattern for matching (or excluding) results}

\item{filter_type}{Character. One or more GitHub search \verb{in} qualifiers.
See \href{https://help.github.com/en/articles/searching-for-repositories}{documentation}
for more details.}

\item{inc_commits}{Logical. Include commit statistics (\code{branch}, \code{commits}, \code{last_update})}

\item{inc_issues}{Logical. Include issue statistics (\code{open_issues}, \code{closed_issues})}

\item{inc_prs}{Logical. Include pull request statistics (\code{open_prs}, \code{merged_prs}, \code{closed_prs})}

\item{exclude}{Logical. Should entries matching the regular expression be excluded or included.}

\item{team_type}{Character. Either "slug" if the team names are slugs or "name" if full team names are provided.}
}
\value{
\code{org_exists()} returns a logical vector.

\code{org_teams()}, \code{org_repos}, and \code{org_repo_search()} return a character vector of team or repo names.

\code{org_team_details()} and \code{org_repo_stats()} return tibbles.
}
\description{
\itemize{
\item \code{org_exists()} - returns \code{TRUE} if the organization(s) exist on GitHub and \code{FALSE} otherwise.
\item \code{org_teams()} - returns a (filtered) vector of organization teams.
\item \code{org_team_details()} - returns a data frame of all organization teams containing identification and permission details.
\item \code{org_repos()} - returns a (filtered) vector of organization repositories.
\item \code{org_repo_search()} - search for repositories within an organization (preferred for large organizations).
\item \code{org_repo_stats()} - returns a tibble of repositories belonging to a GitHub organization along with some
basic statistics about those repositories.
}
}
\examples{
\dontrun{
# Org repos and teams
org_repos("ghclass-test")

org_repos("ghclass-test", filter = "hw1-")

org_teams("ghclass-test")

org_team_details("ghclass-test")
}

}
