% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tests.R
\name{conf.test}
\alias{conf.test}
\title{Test regular (gnp) vs configuration model}
\usage{
conf.test(
  graph,
  directed,
  selfloops,
  nempirical = NULL,
  parallel = NULL,
  seed = NULL
)
}
\arguments{
\item{graph}{adjacency matrix or igraph graph}

\item{directed}{a boolean argument specifying whether object is directed or not.}

\item{selfloops}{a boolean argument specifying whether the model should incorporate selfloops.}

\item{nempirical}{optional, number of graphs to sample from null distribution for empirical distribution.}

\item{parallel}{optional, number of cores to use or boolean for parallel computation.
If passed TRUE uses all cores-1, else uses the number of cores passed. If none passed
performed not in parallel.}

\item{seed}{optional integer}
}
\value{
p-value of test.
}
\description{
Likelihood ratio test for gnp vs configuration model.
}
\examples{
data("adj_karate")
conf.test(graph = adj_karate, directed = FALSE, selfloops = FALSE, seed=123)

}
