% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/search.paths.R
\name{search.paths}
\alias{search.paths}
\title{Searches for paths. Ties together highest.mi and return.mis functions.}
\usage{
search.paths(
  base_syntax,
  fixed_syntax,
  add_syntax,
  n_paths,
  data_list,
  elig_paths,
  prop_cutoff,
  n_subj,
  chisq_cutoff,
  subgroup_stage = FALSE,
  ms_allow = FALSE,
  ms_tol = 1e-06,
  hybrid = F,
  dir_prop_cutoff = 0
)
}
\arguments{
\item{base_syntax}{A character vector containing syntax that never changes.}

\item{fixed_syntax}{A character vector containing syntax that does not change
in a given stage of searching.}

\item{add_syntax}{A character vector containing the syntax that is allowed
to change in a given stage of searching.}

\item{n_paths}{The number of paths present in a given stage of searching.
Equal to the number of paths in add_syntax.}

\item{data_list}{A list of datasets to be used in a given stage of the 
search. Varies based on group, subgroup, or individual-level stage.}

\item{elig_paths}{A character vector containing eligible paths that
gimme is allowed to add to the model at a given stage.}

\item{prop_cutoff}{The proportion of individuals for whom a path must be
nonsignificant in order for it to be dropped from the models. NULL if used 
at the individual-level.}

\item{n_subj}{The number of subjects in a given stage of the search. If
in the group stage, n_subj equals the number of subjects. If in the subgroup
stage, n_subj equals the number of individuals in a given subgroup. At the 
individual stage, n_subj = 1.}

\item{chisq_cutoff}{Cutoff used in order for MI to be considered significant.
Value varies depending on stage of search (e.g., group, subgroup, 
individual).}

\item{subgroup_stage}{Logical. Only present in order to instruct gimme
what message to print to console using writeLines.}
}
\value{
Returns updated values of n_paths and add_syntax.
}
\description{
Searches for paths. Ties together highest.mi and return.mis functions.
}
\keyword{internal}
