% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/updateInventory.R
\name{updateInventory}
\alias{updateInventory}
\title{Update GIMMS 3G file inventory}
\usage{
updateInventory(sort = TRUE, quiet = TRUE)
}
\arguments{
\item{sort}{'logical'. Determines whether or not to sort the list of
available GIMMS files in ascending order of time via
\code{\link{rearrangeFiles}}.}

\item{quiet}{'logical'. If TRUE, information sent to the console is reduced.}
}
\value{
A vector of online filepaths.
}
\description{
Download the latest version of the GIMMS 3G file inventory from the NASA Ames
Ecological Forecasting Lab's FTP server
(\url{http://ecocast.arc.nasa.gov/data/pub/gimms/3g.v0/}, accessed on
January 15, 2016) or, if the server is not accessible, load local version of
the file inventory.
}
\examples{
updateInventory()

}
\author{
Florian Detsch
}
\seealso{
\code{\link{rearrangeFiles}}.
}

