% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/branch.R
\name{branch_rename}
\alias{branch_rename}
\title{Rename a branch}
\usage{
branch_rename(branch = NULL, name = NULL, force = FALSE)
}
\arguments{
\item{branch}{Branch to rename}

\item{name}{The new name for the branch}

\item{force}{Overwrite existing branch. Default is FALSE}
}
\value{
invisible renamed \code{git_branch} object
}
\description{
Rename a branch
}
\examples{
\dontrun{
## Initialize a temporary repository
path <- tempfile(pattern="git2r-")
dir.create(path)
repo <- init(path)

## Config user and commit a file
config(repo, user.name="Alice", user.email="alice@example.org")
writeLines("Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do",
           file.path(path, "example.txt"))
add(repo, "example.txt")
commit(repo, "First commit message")

## Rename 'master' branch to 'dev'
branches(repo)
branch_rename(repository_head(repo), "dev")
branches(repo)
}
}
