% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gkwfit.R
\name{summary.gkwfit}
\alias{summary.gkwfit}
\title{Summary Method for gkwfit Objects}
\usage{
\method{summary}{gkwfit}(object, correlation = FALSE, ...)
}
\arguments{
\item{object}{An object of class \code{"gkwfit"}, typically the result of a call
to \code{\link{gkwfit}}.}

\item{correlation}{Logical; if \code{TRUE}, the correlation matrix of the estimated
parameters is computed from the \code{vcov} component and included in the
summary. Defaults to \code{FALSE}.}

\item{...}{Additional arguments (currently unused).}
}
\value{
An object of class \code{"summary.gkwfit"}, which is a list containing:
\item{call}{The original function call.}
\item{family}{The specified distribution family.}
\item{coefficients}{A matrix of estimates, standard errors, z-values, and p-values. Contains NAs if SEs could not be computed.}
\item{loglik}{The maximized log-likelihood value (numeric).}
\item{df}{The number of estimated parameters.}
\item{aic}{Akaike Information Criterion.}
\item{bic}{Bayesian Information Criterion.}
\item{aicc}{Corrected Akaike Information Criterion.}
\item{nobs}{Number of observations used in fitting (integer).}
\item{convergence}{The convergence code returned by the optimizer.}
\item{message}{The message returned by the optimizer.}
\item{se_available}{Logical indicating if standard errors could be computed.}
\item{correlation}{The correlation matrix of coefficients (if \code{correlation = TRUE} and calculable), otherwise \code{NULL}.}
\item{fixed}{A named list of parameters that were held fixed during estimation, or \code{NULL}.}
\item{fit_method}{The primary fitting method specified ('tmb' or 'nr').}
\item{optimizer_method}{The specific optimizer used (e.g., 'nlminb', 'optim', 'Newton-Raphson').}
}
\description{
Calculates and prepares a detailed summary of a model fitted by \code{\link{gkwfit}}.
This includes coefficients, standard errors, test statistics (z-values), p-values,
log-likelihood, information criteria (AIC, BIC, AICc), number of estimated
parameters, convergence status, and optimizer details.
}
\details{
This function computes standard errors, z-values (\eqn{Estimate / SE}), and
p-values (two-tailed test based on the standard normal distribution) for the
estimated model parameters by utilizing the coefficient estimates (\code{coef})
and their variance-covariance matrix (\code{vcov}). This requires that the
variance-covariance matrix was successfully computed and is available in the
\code{object} (typically requires \code{hessian = TRUE} in the original
\code{\link{gkwfit}} call and successful Hessian inversion).

If standard errors cannot be reliably calculated (e.g., \code{vcov} is missing,
invalid, or indicates non-positive variance), the corresponding columns in the
coefficient table will contain \code{NA} values, and the \code{se_available}
flag will be set to \code{FALSE}.

The returned object is of class \code{"summary.gkwfit"}, and its printing is
handled by \code{\link{print.summary.gkwfit}}.
}
\examples{
\donttest{
# Generate data and fit model
set.seed(2203)
y <- rkw(50, alpha = 2, beta = 3)
fit <- gkwfit(data = y, family = "kw", plot = FALSE)

# Display detailed summary with parameter estimates and standard errors
summary(fit)

# Control digits in output
summary(fit, digits = 4)
}

}
\seealso{
\code{\link{gkwfit}}, \code{\link{print.summary.gkwfit}}, \code{\link{coef.gkwfit}}, \code{\link{vcov.gkwfit}}, \code{\link{logLik.gkwfit}}, \code{\link{AIC.gkwfit}}
}
\author{
Lopes, J. E. (with refinements)
}
\keyword{methods}
\keyword{summary}
