% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gkwgof.R
\name{extract_gof_stats}
\alias{extract_gof_stats}
\title{Extract Key Statistics from gkwgof Objects}
\usage{
extract_gof_stats(..., statistics = "all")
}
\arguments{
\item{...}{One or more objects of class "gkwgof", or a list of such objects.}

\item{statistics}{Character vector specifying which statistics to include. Available options are:
"all" (default), "information" (for AIC, BIC), "distance" (for KS, AD),
"correlation" (for P-P, Q-Q correlations), or "prediction" (for RMSE, MAE).}
}
\value{
A data frame containing the requested statistics for each gkwgof object.
}
\description{
Extracts the most important goodness-of-fit statistics from one or more gkwgof objects
into a concise data frame format for easy comparison and reporting.
}
\examples{
\donttest{
# Generate sample data
set.seed(123)
data <- rkw(n = 200, alpha = 2.5, beta = 1.8)

# Fit multiple models
fit_kw <- gkwfit(data, family = "kw")
fit_beta <- gkwfit(data, family = "beta")

# Calculate goodness-of-fit statistics for each model
gof_kw <- gkwgof(fit_kw, print_summary = FALSE)
gof_beta <- gkwgof(fit_beta, print_summary = FALSE)

# Extract key statistics
summary_stats <- extract_gof_stats(gof_kw, gof_beta)
print(summary_stats)

# Extract only information criteria
ic_stats <- extract_gof_stats(gof_kw, gof_beta, statistics = "information")
print(ic_stats)
}

}
