% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gkwreg-methods.R
\name{nobs.gkwreg}
\alias{nobs.gkwreg}
\title{Number of Observations for GKw Regression Models}
\usage{
\method{nobs}{gkwreg}(object, ...)
}
\arguments{
\item{object}{An object of class \code{"gkwreg"}, typically obtained from
\code{\link{gkwreg}}.}

\item{...}{Currently not used.}
}
\value{
Integer representing the number of observations used in model fitting.
}
\description{
Extracts the number of observations from a fitted Generalized Kumaraswamy
regression model.
}
\examples{
\donttest{
data(GasolineYield)
fit <- gkwreg(yield ~ batch + temp, data = GasolineYield, family = "kw")
nobs(fit)
}

}
\seealso{
\code{\link{gkwreg}}
}
\author{
Lopes, J. E.
}
