% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main.R
\name{print.summary.glmglrt}
\alias{print.summary.glmglrt}
\title{Prints the summary generated by \code{\link{summarylr}}}
\usage{
\method{print}{summary.glmglrt}(
  x,
  ...,
  has.Pvalue = TRUE,
  tst.ind = 3,
  debuglevel = NULL,
  keep.wald = NULL
)
}
\arguments{
\item{x}{a \code{summary.glmglrt} object generated by \code{\link{summarylr}}.}

\item{...}{additional arguments passed to \code{\link[stats:summary.glm]{stats::print.summary.glm}} then \code{\link[stats:printCoefmat]{printCoefmat}}. The most useful ones are \code{digits} and \code{signif.stars}.}

\item{has.Pvalue}{logical value; passed to \code{\link[stats:printCoefmat]{printCoefmat}}; if TRUE, the P-value column is formatted by \code{\link[base:format.pval]{format.pval}}.}

\item{tst.ind}{integer vector of length>=0; passed to \code{\link[stats:printCoefmat]{printCoefmat}}; it changes the format of these columns, assuming they are statistics columns.}

\item{debuglevel}{NULL or integer value; set to NULL to use the debuglevel argument that was specified in  \code{\link{summarylr}}, 0 (default) to disable warnings, 1 to enable warnings and 2 to enable warnings and notes.}

\item{keep.wald}{NULL or logical; set to NULL to use the keep.wald argument that was specified in \code{\link{summarylr}}. If TRUE, the standard Wald's P-values are displayed. If FALSE, the standard Wald's P-values are hidden.}
}
\description{
This function prints a \code{summary.glmglrt} object generated by \code{\link{summarylr}}.
It works like the standard \code{\link[stats:summary.glm]{summary.glm}} function but additionnally
displays columns showing Rao or LRT P-values.
}
\examples{
model = glm(family="binomial", cbind(50,30) ~ 1)
print(summarylr(model),signif.stars=FALSE,digits=10)

}
\seealso{
Other Extended GLM summary functions: 
\code{\link{override_summary}()},
\code{\link{summarylr}()}
}
\concept{Extended GLM summary functions}
