% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/formula_data_edits.R
\name{glFormula_edit}
\alias{glFormula_edit}
\title{Extracting Useful Vectors and Matrices from Formula and Data Information}
\usage{
glFormula_edit(
  formula,
  data = NULL,
  family,
  subset,
  weights,
  na.action,
  offset,
  ...
)
}
\arguments{
\item{formula}{a two-sided linear formula object describing both the fixed-effects and 
random-effects part of the model, with the response on the left of a ~ operator and the terms, 
sepearated by + operators, on the right. Random-effects terms are distinguished by vertical bars 
("|") separating expression for design matrices from grouping factors. \code{formula} should be 
of the same format needed for \code{\link[lme4]{glmer}} in package \pkg{lme4}. Only one grouping factor 
will be recognized. The random effects covariates need to be a subset of the fixed effects covariates.
The offset must be specified outside of the formula in the 'offset' argument.}

\item{data}{an optional data frame containing the variables named in \code{formula}. Although 
\code{data} is optional, the package authors \emph{strongly} recommend its use. If \code{data} is 
omitted, variables will be taken from the environment of \code{formula} (if specified as a formula).}

\item{family}{a description of the error distribution and link function to be used in the model 
(a family function or the result of a call to a family function).
(See \link{family} for details of family functions.)}

\item{subset}{an optional vector specifying a subset of observations to be used in the fitting process.}

\item{weights}{an optional vector of ‘prior weights’ to be used in the fitting process. Should be NULL or a numeric vector.}

\item{na.action}{a function that indicates what should happen when the data contain NAs. The default
option \code{na.omit} removes observations with any missing values in any of the variables}

\item{offset}{this can be used to specify an a priori known component to be included in the linear predictor during fitting. 
This should be NULL or a numeric vector of length equal to the number of cases.}

\item{...}{potential further arguments}
}
\value{
a list with the following elements:
\item{fr}{a model frame including all fixed and random covariates, the response, and the 
grouping variable}
\item{X}{fixed effects covariates model matrix}
\item{reTrms}{list containing several items relating to the random effects} 
\item{family}{family specified for data modeling}
\item{formula}{formula}
\item{fixed_vars}{vector of variable names used for fixed effects}
\item{fwmsgs}{indicator for a check of the group levels}
}
\description{
Takes the model \code{formula} and an optional data frame and converts them into y, X, Z, and group output.
}
