% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary_lmmSeq.R
\name{summary.lmmSeq}
\alias{summary.lmmSeq}
\alias{summary.GlmmSeq}
\title{Summarise a 'glmmSeq'/'lmmSeq' object}
\usage{
\method{summary}{lmmSeq}(object, gene = NULL, digits = max(3L, getOption("digits") - 3L), ...)

\method{summary}{GlmmSeq}(object, gene = NULL, ...)
}
\arguments{
\item{object}{an object of class \code{"GlmmSeq"} or \code{"lmmSeq"}}

\item{gene}{an optional character value specifying a single gene whose
results are summarised}

\item{digits}{integer, used for number formatting}

\item{...}{arguments to be passed to other methods}
}
\value{
If \code{gene=NULL} a dataframe of results for all genes is returned. Otherwise
the output of GLMM or LMM model results for a single gene including
coefficients, test statistics, p-values is printed and the dataframe for all
genes is returned invisibly.
}
\description{
Summarise results from \link{glmmSeq} or \link{lmmSeq} analysis
}
\seealso{
\code{\link[=glmmSeq]{glmmSeq()}}, \code{\link[=lmmSeq]{lmmSeq()}}
}
