% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\name{confint.glmmTMB}
\alias{confint.glmmTMB}
\title{Calculate confidence intervals}
\usage{
\method{confint}{glmmTMB}(
  object,
  parm = NULL,
  level = 0.95,
  method = c("wald", "Wald", "profile", "uniroot"),
  component = c("all", "cond", "zi", "other"),
  estimate = TRUE,
  include_nonest = FALSE,
  parallel = c("no", "multicore", "snow"),
  ncpus = getOption("profile.ncpus", 1L),
  cl = NULL,
  full = FALSE,
  ...
)
}
\arguments{
\item{object}{\code{glmmTMB} fitted object.}

\item{parm}{which parameters to profile, specified
\itemize{
\item by index (position) [\emph{after} component selection for \code{confint}, if any]
\item by name (matching the row/column names of \code{vcov(object,full=TRUE)})
\item as \code{"theta_"} (random-effects variance-covariance parameters), \code{"beta_"} (conditional and zero-inflation parameters), or \code{"disp_"} or \code{"sigma"} (dispersion parameters)
}
 Parameter indexing by number may give unusual results when
 some parameters have been fixed using the \code{map} argument:
 please report surprises to the package maintainers.}

\item{level}{Confidence level.}

\item{method}{'wald', 'profile', or 'uniroot': see Details
function)}

\item{component}{Which of the three components 'cond', 'zi' or
'other' to select. Default is to select 'all'.}

\item{estimate}{(logical) add a third column with estimate ?}

\item{include_nonest}{include dummy rows for non-estimated (mapped, rank-deficient) parameters?}

\item{parallel}{method (if any) for parallel computation}

\item{ncpus}{number of CPUs/cores to use for parallel computation}

\item{cl}{cluster to use for parallel computation}

\item{full}{CIs for all parameters (including dispersion) ?}

\item{...}{arguments may be passed to \code{\link{profile.glmmTMB}} (and possibly from there to \code{\link{tmbprofile}}) or
\code{\link[TMB]{tmbroot}}}
}
\description{
Calculate confidence intervals
}
\details{
Available methods are
\describe{
\item{"wald"}{These intervals are based on the standard errors
calculated for parameters on the scale
of their internal parameterization depending on the family. Derived
quantities such as standard deviation parameters and dispersion
parameters are back-transformed. It follows that confidence
intervals for these derived quantities are typically asymmetric.}
\item{"profile"}{This method computes a likelihood profile
for the specified parameter(s) using \code{profile.glmmTMB};
fits a spline function to each half of the profile; and
inverts the function to find the specified confidence interval.}
\item{"uniroot"}{This method uses the \code{\link{uniroot}}
function to find critical values of one-dimensional profile
functions for each specified parameter.}
}
At present, "wald" returns confidence intervals for variance
parameters on the standard deviation/correlation scale, while
"profile" and "uniroot" report them on the underlying ("theta")
scale: for each random effect, the first set of parameter values
are standard deviations on the log scale, while remaining parameters
represent correlations on the scaled Cholesky scale. For a random
effects model with two elements (such as a random-slopes model,
or a random effect of factor with two levels), there is a single
correlation parameter \eqn{\theta}{theta}; the correlation is
equal to \eqn{\rho = \theta/\sqrt{1+\theta^2}}{rho = theta/sqrt{1+theta^2}}.
For random-effects terms with more than two elements, the mapping
is more complicated: see https://github.com/glmmTMB/glmmTMB/blob/master/misc/glmmTMB_corcalcs.ipynb
}
\examples{
data(sleepstudy, package="lme4")
model <- glmmTMB(Reaction ~ Days + (1|Subject), sleepstudy)
model2 <- glmmTMB(Reaction ~ Days + (1|Subject), sleepstudy,
    dispformula= ~I(Days>8))
confint(model)  ## Wald/delta-method CIs
confint(model,parm="theta_")  ## Wald/delta-method CIs
confint(model,parm=1,method="profile")
}
