% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{genCholD}
\alias{genCholD}
\title{Generates the Cholesky decomposition covariance matrix of the random effects}
\usage{
genCholD(cov, data, eff_range, gamma)
}
\arguments{
\item{cov}{An integer matrix with columns of block identifier, dimension of block, function definition, number of varaibles
in the argument to the funciton, and index of the parameters, respectively. Rows are specific functions of each block.}

\item{data}{Vector of data. Created by flattening the matrices in column-major order of the data used in each block.}

\item{eff_range}{Vector of values with the effective range parameters of the covariance functions, where required.}

\item{gamma}{Vector of parameters used to generate the matrix D.}
}
\value{
A lower triangular matrix
}
\description{
Generates the Cholesky Decomposition of the covariance matrix of the random effects. Used internally in the Covariance class.
}
