% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extrafunctions.R
\docType{data}
\name{SimGeospat}
\alias{SimGeospat}
\title{Simulated data from a geospatial study with continuous outcomes}
\description{
Simulated data from a geospatial study with continuous outcomes
}
\examples{
#Data were generated with the following code:
n <- 600
SimGeospat <- data.frame(x = runif(n,-1,1), y = runif(n,-1,1))

sim_model <- Model$new(
  formula = ~ (1|fexp(x,y)),
  data = SimGeospat,
  covariance = c(0.25,0.8),
  mean = c(0),
  family = gaussian()
)

SimGeospat$y <- sim_model$sim_data()
}
