% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cv.glmnetr_230508.R
\name{glmnetr.foldid}
\alias{glmnetr.foldid}
\title{Set up random folds stratified by a 0, 1 indicator}
\usage{
glmnetr.foldid(folds_n = 10, event)
}
\arguments{
\item{folds_n}{number of folds to set up}

\item{event}{0, 1 indicator variable for stratification}
}
\value{
a vector of fold ids with folds_n levels and length that of event
}
\description{
Set up random folds stratified by a 0, 1 indicator
}
\examples{
# set seed for random numbers, optionally, to get reproducible results
set.seed(82545038)
sim.data=glmnetr.simdata(nrows=1011, ncols=25, beta=NULL)
event=sim.data$event
foldid = glmnetr.foldid(folds_n=10, event)
table(event, foldid)
table(table(foldid))
}
