% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ann_tab_cv_240322.R
\name{wtlast}
\alias{wtlast}
\title{Construct the weights for going from the last hidden layer to the last layer of 
the model, not counting any activation, to carry forward an offset to mimic a linear model}
\usage{
wtlast(tnsr, lasso = 0, lscale = 5, scale = 1, rreturn = 1, trnspose = 0)
}
\arguments{
\item{tnsr}{an input tensor which is to be modified to mimic the linear term of a 
generalized linear model, e.g a Cox or logistic regression model}

\item{lasso}{1 if the first column is the linear estimate from a linear model, 
often a lasso model}

\item{lscale}{Scale used to allow ReLU to exend +/- lscale before capping the 
inputted linear estimated}

\item{scale}{Scale used to transform the inital random paramter assingments by 
dividing by scale}

\item{rreturn}{1 (default) to return an R (numeric) vector, 0 to return a torch tensor}

\item{trnspose}{1 to transpose the matrix before returning, 0 to not.}
}
\value{
a weight matrix in tensor format
}
\description{
Construct the weights for going from the last hidden layer to the last layer of 
the model, not counting any activation, to carry forward an offset to mimic a linear model
}
