% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.nested.glmnetr_241104.R
\name{print.nested.glmnetr}
\alias{print.nested.glmnetr}
\title{A redirect to the summary() function for nested.glmnetr() output objects}
\usage{
\method{print}{nested.glmnetr}(x, ...)
}
\arguments{
\item{x}{a nested.glmnetr() output object.}

\item{...}{additional pass through inputs for the print function.}
}
\value{
- a nested cross validation fit summary, or a cross validation model summary.
}
\description{
A redirect to the summary() function for nested.glmnetr() output objects
}
\examples{
\donttest{
sim.data=glmnetr.simdata(nrows=1000, ncols=100, beta=NULL)
xs=sim.data$xs 
y_=sim.data$yt
event=sim.data$event
# for this example we use a small number for folds_n to shorten run time 
fit3 = nested.glmnetr(xs, NULL, y_, event, family="cox", folds_n=3)  
print(fit3)
}

}
\seealso{
\code{\link{summary.nested.glmnetr}} , \code{\link{nested.glmnetr}}
}
