% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cv.glmtlp.R
\name{cv.glmtlp}
\alias{cv.glmtlp}
\title{Cross-validation for glmtlp}
\usage{
cv.glmtlp(X, y, ..., seed = NULL, nfolds = 10, obs.fold = NULL, ncores = 1)
}
\arguments{
\item{X}{input matrix, of dimension \code{nobs} x \code{nvars}, as in 
\code{glmtlp}.}

\item{y}{response, of length nobs, as in \code{glmtlp}.}

\item{\dots}{Other arguments that can be passed to \code{glmtlp}}

\item{seed}{the seed for reproduction purposes}

\item{nfolds}{number of folds; default is 10. Although \code{nfolds} can be
as large as the sample size (leave-one-out CV), it is not recommended for
large datasets. The smallest value allowable is \code{nfolds=3}}

\item{obs.fold}{an optional vector of values between 1 and \code{nfolds}
identifying what fold each observation is in. If supplied, \code{nfolds} can
be missing.}

\item{ncores}{number of cores utilized; default is 1. If greater than 1, 
then use \code{doParallel::foreach} to fit each fold; if equal to 1, then 
use for loop to fit each fold. No need to register parallel outside.}
}
\value{
an object of class \code{"cv.glmtlp"} is returned, which is a list
  with the ingredients of the cross-validation fit. 

\item{call}{the function call}
\item{cv.mean}{The mean cross-validated error - a vector of length
  \code{length(kappa)} if \code{penalty = "l0"} and a vector of length 
  \code{length{lambda}} otherwise.} 
\item{cv.se}{estimate of standard error of \code{cv.mean}.} 
\item{fit}{a fitted glmtlp object for the full data.} 
\item{idx.min}{the index of the \code{lambda} or \code{kappa} sequence that 
  corresponding to the smallest cv mean error.}
\item{kappa}{the values of \code{kappa} used in the fits, available when 
  penalty = 'l0'.}
\item{kappa.min}{the value of \code{kappa} that gives the minimum 
  \code{cv.mean}, available when penalty is 'l0'. }
\item{lambda}{the values of \code{lambda} used in the fits.} 
\item{lambda.min}{value of \code{lambda} that gives minimum \code{cv.mean},  
  available when penalty is 'l1' or 'tlp'.} 
\item{null.dev}{null deviance of the model.}
\item{obs.fold}{the fold id for each observation used in the CV.}
}
\description{
Does k-fold cross-validation for glmtlp, produces a plot, and returns a
value for \code{lambda} (or \code{kappa} if \code{penalty="l0"}).
}
\details{
The function runs \code{glmtlp} \code{nfolds}+1 times; the first to get the
  \code{lambda} or \code{kappa} sequence, and then the remainder to compute 
  the fit with each of the folds omitted. The error is accumulated, and the 
  average (haven't finished yet) error and standard deviation over the folds 
  is computed.
}
\examples{

# Gaussian
X <- matrix(rnorm(100 * 20), 100, 20)
y <- rnorm(100)
cv.fit <- cv.glmtlp(X, y, family = "gaussian", penalty = "l1", seed=2021)

# Binomial
X <- matrix(rnorm(100 * 20), 100, 20)
y <- sample(c(0,1), 100, replace = TRUE)
cv.fit <- cv.glmtlp(X, y, family = "binomial", penalty = "l1", seed=2021)

}
\references{
Shen, X., Pan, W., & Zhu, Y. (2012). 
  \emph{Likelihood-based selection and sharp parameter estimation. 
  Journal of the American Statistical Association, 107(497), 223-232.}
  \cr Yang, Y., & Zou, H. (2014). \emph{A coordinate majorization descent algorithm 
  for l1 penalized learning. Journal of Statistical Computation and 
  Simulation, 84(1), 84-95.}
  \cr Two R package Github: \emph{ncvreg} and \emph{glmnet}.
}
\seealso{
\code{glmtlp} and \code{plot}, \code{predict}, and \code{coef}
methods for \code{"cv.glmtlp"} objects.
}
\author{
Chunlin Li, Yu Yang, Chong Wu
  \cr Maintainer: Yu Yang \email{yang6367@umn.edu}
}
\keyword{models}
\keyword{regression}
