% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/glms.R
\name{ROCc}
\alias{ROCc}
\title{The Receiver Operating Characteristic (ROC) Curve}
\usage{
ROCc(object, plot.it = TRUE, verbose = TRUE, ...)
}
\arguments{
\item{object}{a matrix with two columns: the first one is a numeric vector of 1's and 0's indicating whether each row is a "success" or a "failure"; the second one is a numeric vector of values indicating the probability (or propensity score) of each row to be a "success". Optionally, \code{object} can be an object of the class glm which is obtained from the fit of a generalized linear model where the distribution of the response variable is assumed to be binomial.}

\item{plot.it}{an (optional) logical switch indicating if the plot of the ROC curve is required or just the data matrix in which it is based. By default, \code{plot.it} is set to be TRUE.}

\item{verbose}{an (optional) logical switch indicating if should the report of results be printed. By default, \code{verbose} is set to be TRUE.}

\item{...}{further arguments passed to or from other methods. For example, if \code{plot.it=TRUE} then \code{...} may to include graphical parameters as \code{col}, \code{pch}, \code{cex}, \code{main}, \code{sub}, \code{xlab}, \code{ylab}.}
}
\value{
A list which contains the following objects:
\itemize{
\item{\code{roc:}}{ A matrix with the Cutoffs and the associated estimates of Sensitivity and Specificity.}
\item{\code{auroc:}}{ The exact area under the ROC curve.}
\item{\code{gini:}}{ The value of the Gini coefficient computed as 2(\code{auroc}-0.5).}
\item{\code{ks:}}{ The value of the Kolmogorov-Smirnov statistic computed as the maximum value of |1-Sensitivity-Specificity|.}
}
}
\description{
Computes the exact area under the ROC curve (AUROC), the Gini coefficient, and the Kolmogorov-Smirnov (KS) statistic for a binary classifier. Optionally, this function can plot the ROC curve, that is, the plot of the estimates of Sensitivity versus the estimates of 1-Specificity.
}
\examples{
burn1000 <- aplore3::burn1000

## splitting the sample
## 70\% for the training sample and 30\% for the validation sample
burn1000 <- within(burn1000, sampleof <- "validation")
s <- sample(nrow(burn1000),nrow(burn1000)*0.7)
burn1000$sampleof[s] <- "training"

mod <- death ~ age + tbsa + inh_inj + age*inh_inj + tbsa*inh_inj
training <- subset(burn1000,sampleof=="training")
fit <- glm(mod, family=binomial("logit"), data=training)

## ROC curve for the training sample
ROCc(fit, col="red", col.lab="blue", col.axis="black",
     col.main="black", family="mono")

validation <- subset(burn1000, sampleof=="validation")
probs <- predict(fit, newdata=validation, type="response")
responses <- with(validation, ifelse(death=="Dead",1,0))

## ROC curve for the validation sample
ROCc(cbind(responses,probs), col="red", col.lab="blue",
     col.axis="black", col.main="black", family="mono")
}
\references{
Hanley J.A. and McNeil B.J. (1982) The Meaning and Use of the Area under a Receiver Operating Characteristic (ROC) Curve. \emph{Radiology} 143, 29–36.
}
