% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geeglm.R
\name{SGPC}
\alias{SGPC}
\title{SGPC for Generalized Estimating Equations}
\usage{
SGPC(..., verbose = TRUE)
}
\arguments{
\item{...}{one or several objects of the class \emph{glmgee}.}

\item{verbose}{an (optional) logical switch indicating if should the report of results be printed. By default, \code{verbose} is set to be TRUE.}
}
\value{
A \code{data.frame} with the values of the gaussian pseudo-likelihood, the number of parameters in the linear predictor plus the number of parameters in the correlation matrix, and the value of SGPC for each \emph{glmgee} object in the input.
}
\description{
Computes the Schwarz-type penalized Gaussian pseudo-likelihood criterion (SGPC) for one or more objects of the class glmgee.
}
\examples{
###### Example 1: Effect of ozone-enriched atmosphere on growth of sitka spruces
mod1 <- size ~ poly(days,4) + treat
fit1 <- glmgee(mod1, id=tree, family=Gamma("log"), data=spruces)
fit2 <- update(fit1, corstr="AR-1")
fit3 <- update(fit1, corstr="Stationary-M-dependent(2)")
fit4 <- update(fit1, corstr="Exchangeable")
SGPC(fit1, fit2, fit3, fit4)

###### Example 2: Treatment for severe postnatal depression
mod2 <- depressd ~ visit + group
fit1 <- glmgee(mod2, id=subj, family=binomial("logit"), data=depression)
fit2 <- update(fit1, corstr="AR-1")
fit3 <- update(fit1, corstr="Stationary-M-dependent(2)")
fit4 <- update(fit1, corstr="Exchangeable")
SGPC(fit1, fit2, fit3, fit4)

###### Example 3: Treatment for severe postnatal depression (2)
mod3 <- dep ~ visit*group
fit1 <- glmgee(mod3, id=subj, family=gaussian("identity"), data=depression)
fit2 <- update(fit1, corstr="AR-1")
fit3 <- update(fit1, corstr="Exchangeable")
SGPC(fit1, fit2, fit3)

}
\references{
Carey, V.J. and Wang, Y.-G. (2011) Working covariance model selection for
generalized estimating equations. \emph{Statistics in Medicine} 30, 3117-3124.

Zhu, X. and Zhu, Z. (2013) Comparison of Criteria to Select Working Correlation
Matrix in Generalized Estimating Equations. \emph{Chinese Journal of Applied Probability
and Statistics} 29, 515-530.

Fu, L. and Hao, Y. and Wang, Y.-G. (2018) Working correlation structure
selection in generalized estimating equations. \emph{Computational Statistics} 33,
983-996.
}
\seealso{
\link{QIC}, \link{CIC}, \link{RJC}, \link{GHYC}, \link{AGPC}
}
