% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{mammary}
\alias{mammary}
\title{Ability of retinyl acetate to prevent mammary cancer in rats}
\format{
A data frame with 48 rows and 2 variables:
\describe{
  \item{group}{a factor giving the group to which the rat was assigned: "retinoid" or "control".}
  \item{tumors}{a numeric vector giving the number of tumors identified on the rat.}
}
}
\usage{
data(mammary)
}
\description{
A total of 76 female rats were injected with a carcinogen for
mammary cancer. Then, all animals were given retinyl acetate (retinoid) to
prevent mammary cancer for 60 days. After this phase, the 48 animals that
remained tumor-free were randomly assigned to continue the retinoid prophylaxis
or control. Rats were then palpated for tumors twice weekly, and observations
ended 182 days after the initial carcinogen injections began. The main objective
of analysis was to assess the difference in the development of tumors between
the treated and control groups. See Morel and Nagaraj (2012, page 63).
}
\examples{
boxplot(tumors ~ group, data=mammary, outline=FALSE, xlab="Group",
        ylab="Number of tumors", col=c("yellow","blue"))
}
\references{
Lawless, J.F. (1987) Regression Methods for Poisson Process Data. \emph{Journal of the American
Statistical Association}, 82, 808-815.

Morel, J.G. and Nagaraj, N.K. (2012) \emph{Overdispersion Models in SAS}. SAS Institute Inc., Cary, North Carolina, USA.
}
\keyword{datasets}
