% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geeglm.R
\name{vcov.glmgee}
\alias{vcov.glmgee}
\title{Estimate of the variance-covariance matrix in GEEs}
\usage{
\method{vcov}{glmgee}(
  object,
  ...,
  type = c("robust", "df-adjusted", "model", "bias-corrected", "jackknife")
)
}
\arguments{
\item{object}{An object of the class \emph{glmgee}.}

\item{...}{further arguments passed to or from other methods.}

\item{type}{an (optional) character string indicating the type of estimator which should be used. The available options are: robust sandwich-type estimator ("robust"), degrees-of-freedom-adjusted estimator ("df-adjusted"), bias-corrected estimator ("bias-corrected"), and the model-based or naive estimator ("model"). By default, \code{type} is set to be "robust".}
}
\value{
A \code{matrix} with the type-\code{type} estimate of the variance-covariance matrix.
}
\description{
Computes the type-\code{type} estimate of the variance-covariance matrix from an object of the class glmgee.
}
\examples{
###### Example 1: Effect of ozone-enriched atmosphere on growth of sitka spruces
mod <- size ~ poly(days,4) + treat
fit1 <- glmgee(mod, id=tree, family=Gamma("log"), data=spruces, corstr="Exchangeable")
vcov(fit1)
vcov(fit1,type="bias-corrected")

###### Example 2: Treatment for severe postnatal depression
mod <- depressd ~ visit + group
fit3 <- glmgee(mod, id=subj, family=binomial("logit"), corstr="AR-1", data=depression)
vcov(fit3)
vcov(fit3,type="bias-corrected")

###### Example 3: Treatment for severe postnatal depression (2)
mod <- dep ~ visit*group
fit2 <- glmgee(mod, id=subj, family=gaussian("identity"), corstr="AR-1", data=depression)
vcov(fit2)
vcov(fit2,type="bias-corrected")

}
\references{
Mancl, L.A. and DeRouen, T.A. (2001) A Covariance Estimator for GEE with Improved Small-Sample Properties. \emph{Biometrics} 57, 126-134.
}
