% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{amenorrhea}
\alias{amenorrhea}
\title{amenorrhea}
\format{
A data frame with 4604 rows and 4 variables:
\describe{
  \item{ID}{a numeric vector indicating the woman's ID.}
  \item{Dose}{a factor with two levels: "100mg" for treatment with 100 mg injection; and "150mg" for treatment with 150 mg injection.}
  \item{Time}{a numeric vector indicating the number of 90-day intervals since the trial beagn.}
  \item{amenorrhea}{a numeric vector indicating the amenorrhea status (1 for amenorrhea; 0 otherwise).}
}
}
\usage{
data(amenorrhea)
}
\description{
A total of 1151 women completed menstrual diaries and
the diary data were used to generate binary sequence for each woman,
indicating whether or not she had experienced amenorrhea (the
absence of menstrual bleeding for a specified number of days) on
the day of randomization and three additional 90-day intervals. The
goal of this trial was to compare the two treatments (100 mg or 150
mg of depot-medroxyprogesterone acetate (DMPA)) in terms of how the
rates of amenorrhea change over time with continued use of the
contraceptive method.
}
\examples{
data(amenorrhea)
dev.new()
amenorrhea2 <- aggregate(amenorrhea ~ Time + Dose,mean,data=amenorrhea,na.rm=TRUE)
barplot(100*amenorrhea ~ Dose+Time,data=amenorrhea2,beside=TRUE,col=c("blue","yellow"),ylab="\%")
legend("topleft",legend=c("100 mg","150 mg"),fill=c("blue","yellow"),title="Dose",bty="n")
}
\references{
Fitzmaurice G.M., Laird N.M., Ware J.H. (2011, page 397). \emph{Applied Longitudinal Analysis. 2nd ed.} John Wiley & Sons.

Machin D., Farley T.M., Busca B., Campbell M.J., d'Arcangues C. (1988) Assessing
changes in vaginal bleeding patterns in contracepting women. \emph{Contraception}, 38, 165-79.
}
\keyword{datasets}
