% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/overglm3.R
\name{zero.excess}
\alias{zero.excess}
\title{Test for zero-excess in Count Regression Models}
\usage{
zero.excess(object, verbose = TRUE)
}
\arguments{
\item{object}{an object of the class \code{glm}, for poisson regression models, or an object of the class \code{overglm}, for negative binomial regression models.}

\item{verbose}{an (optional) logical switch indicating if should the report of results be printed. By default, \code{verbose} is set to be TRUE.}
}
\value{
A matrix with 1 row and the following columns:
\tabular{ll}{
\code{Observed} \tab the observed number of zeros,\cr
\tab \cr
\code{Expected}\tab the expected number of zeros,\cr
\tab \cr
\code{z-value}\tab the value of the statistical test,\cr
\tab \cr
\code{Pr(>z)}\tab the p-value of the statistical test.\cr
}
}
\description{
Allows to assess if the observed number of zeros is significantly higher than expected according to the fitted count regression model (poisson or negative binomial).
}
\details{
According to the formulated count regression model, we have that
\eqn{Y_k\sim P(y;\mu_k,\phi)} for \eqn{k=1,\ldots,n} are independent
random variables. Then, the expected number of zeros is the sum of
\eqn{P(0;\hat{\mu}_k,\hat{\phi})} for \eqn{k=1,\ldots,n}, where
\eqn{\hat{\mu}_k} and \eqn{\hat{\phi}} represent the estimates of
\eqn{\mu_k} and \eqn{\phi}, respectively, obtained from the fitted
model. Thus, the test statistic reduces to the standardized
difference between the observed and expected number of zeros. The
distribution of that statistic, under the null hypothesis, tends
to be the standard normal when the sample size, \eqn{n}, tends to
infinity.
}
\examples{
####### Example 1: Self diagnozed ear infections in swimmers
data(swimmers)
fit1 <- glm(infections ~ frequency + location, family=poisson, data=swimmers)
zero.excess(fit1)
fit2 <- overglm(infections ~ frequency + location, family="nb1", data=swimmers)
zero.excess(fit2)

####### Example 2: Article production by graduate students in biochemistry PhD programs
bioChemists <- pscl::bioChemists
fit1 <- glm(art ~ fem + kid5 + ment, family=poisson, data = bioChemists)
zero.excess(fit1)
fit2 <- overglm(art ~ fem + kid5 + ment, family="nb1", data = bioChemists)
zero.excess(fit2)
####### Example 3: Roots Produced by the Columnar Apple Cultivar Trajan
data(Trajan)
fit1 <- glm(roots ~ photoperiod, family=poisson, data=Trajan)
zero.excess(fit1)
fit2 <- overglm(roots ~ photoperiod, family="nbf", data=Trajan)
zero.excess(fit2)

}
\seealso{
\link{overglm}, \link{zeroinf}
}
