% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print.glmtrans.R
\name{print.glmtrans}
\alias{print.glmtrans}
\title{Print a fitted "glmtrans" object.}
\usage{
\method{print}{glmtrans}(x, ...)
}
\arguments{
\item{x}{fitted \code{"glmtrans"} model object.}

\item{...}{additional arguments.}
}
\value{
No value is returned.
}
\description{
Similar to the usual print methods, this function summarizes results from a fitted \code{"glmtrans"} object.
}
\examples{
set.seed(1, kind = "L'Ecuyer-CMRG")

# fit a linear model
D.training <- models("gaussian", K = 2, p = 500)
fit.gaussian <- glmtrans(D.training$target, D.training$source)

fit.gaussian

}
\seealso{
\code{\link{glmtrans}}.
}
