% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.glmtrans.R
\name{plot.glmtrans}
\alias{plot.glmtrans}
\alias{plot.glmtrans_source_detection}
\title{Visualize the losses of different sources and the threshold to determine transferability.}
\usage{
\method{plot}{glmtrans}(x, ...)
}
\arguments{
\item{x}{an object from class "glmtrans" or "glmtrans_source_detection", which are the output of functions \code{glmtrans} and \code{source_detection}, respectively.}

\item{...}{additional arguments that can be passed to \code{ggplot} function.}
}
\value{
a "ggplot" visualization with the transferable threshold and losses of different sources.
}
\description{
Plot the losses of different sources and the threshold to determine transferability for object with class "glmtrans" or "glmtrans_source_detection".
}
\examples{
set.seed(1, kind = "L'Ecuyer-CMRG")

D.training <- models("gaussian", K = 2, p = 500, Ka = 1)

# plot for class "glmtrans"
fit.gaussian <- glmtrans(D.training$target, D.training$source)
plot(fit.gaussian)

\donttest{
# plot for class "glmtrans_source_detection"
detection.gaussian <- source_detection(D.training$target, D.training$source)
plot(detection.gaussian)
}

}
\references{
Tian, Y. and Feng, Y., 2021. \emph{Transfer learning with high-dimensional generalized linear models. Submitted.}
}
\seealso{
\code{\link{glmtrans}}, \code{\link{source_detection}}, \code{\link[ggplot2]{ggplot}}.
}
