% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/remove_data.r
\name{remove_data}
\alias{remove_data}
\title{Remove data from database tables}
\usage{
remove_data(table, control = NULL, object = NULL)
}
\arguments{
\item{table}{Database table from which the batch should be removed.  Object
of type \code{character}.}

\item{control}{Control batch for which the data is removed Object
of type \code{numeric}.}

\item{object}{Object batch for which the data is removed Object
of type \code{numeric}.}
}
\value{
Message that data has been removed successfully. Data is removed
from database tables.
}
\description{
The function removes data from database tables for control or object batches.
}
\details{
The function removes data "greedily": all data that builds on the deleted
data is removed. For example, when data from \emph{data_control} is removed
data in \emph{data_object} that maps to this control batch is also removed.
The dependency structure works as follows: \emph{batch_keyword} / \emph{batch_time} ->
\emph{data_control} -> \emph{data_object} -> \emph{data_score} -> \emph{data_doi}.
}
\examples{
\dontrun{
remove_data(
  table = "batch_keywords",
  control = 1
)
remove_data(
  table = "data_score",
  control = 1,
  object = 1
)
}

}
\seealso{
\itemize{
\item \code{\link[=example_keywords]{example_keywords()}}
\item \code{\link[=example_time]{example_time()}}
\item \code{\link[=example_control]{example_control()}}
\item \code{\link[=example_object]{example_object()}}
\item \code{\link[=example_score]{example_score()}}
\item \code{\link[=example_doi]{example_doi()}}
}
}
