% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/glottosearch.R
\name{glottosearch}
\alias{glottosearch}
\title{Search within glottodata for languages, glottocodes, etc.}
\usage{
glottosearch(
  search,
  glottodata = NULL,
  partialmatch = TRUE,
  columns = NULL,
  tolerance = NULL
)
}
\arguments{
\item{search}{Character string to search for, this can be the name of a language, a family, a glottocode, isocode.}

\item{glottodata}{Any linguistic or cultural dataset. Default is to search within glottobase.}

\item{partialmatch}{By default, partial matches will be returned as well. In case you only want exact matches, this argument should be set to FALSE.}

\item{columns}{By default, the entire dataset is searched, but optionally the search can be limited to specific columns.}

\item{tolerance}{In case partialmatch is TRUE: what is the maximum difference between search term and match? Default is 0.1}
}
\value{
A subset of glottodata that matches search conditions (object returned as a data.frame/tibble)
}
\description{
Search within glottodata for languages, glottocodes, etc.
}
\examples{
\donttest{
glottosearch(search = "Yucuni")
glottosearch(search = "Yucuni", columns = "name")
glottosearch(search = "Yucuni", columns = c("name", "family"))
}
}
\concept{<glottosearch><glottofilter>}
