% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/md-escape.R
\name{md_escape}
\alias{md_escape}
\title{Backslash escape all punctuation}
\usage{
md_escape(x)
}
\arguments{
\item{x}{A character vector of strings containing punctuation that might
accidentally be considered markdown syntax.}
}
\value{
A character string with all \code{[:punct:]} properly escaped with
prepended backslashes.
}
\description{
Take a character vector containing punctuation and return a glue vector with
every punctuation mark prepended with double escape backslashes.
}
\details{
When trying to format text containing markdown syntax characters, it's
necessary to "escape" those characters so that they are ignored by
formatting.

Any ASCII punctuation character may be backslash-escaped... Escaped
characters are treated as regular characters and do not have their usual
Markdown meanings.
}
\examples{
hashtag <- "# six seasons and a movie"
map_md(md_escape(hashtag), md_bold, n = 6)
}
\seealso{
Other inline functions: \code{\link{md_autolink}},
  \code{\link{md_bold}}, \code{\link{md_code}},
  \code{\link{md_convert}}, \code{\link{md_disallow}},
  \code{\link{md_hardline}}, \code{\link{md_image}},
  \code{\link{md_issue}}, \code{\link{md_italic}},
  \code{\link{md_link}}, \code{\link{md_softline}},
  \code{\link{md_strike}}, \code{\link{md_text}}
}
\concept{inline functions}
