% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/normalization.R
\name{tanorm}
\alias{tanorm}
\title{Total Area Normalization of glycan data}
\usage{
tanorm(data, glyco.names = NULL)
}
\arguments{
\item{data}{data frame which holds columns representing Glycans.}

\item{glyco.names}{names of columns that represent glycan data. If \code{NULL}
all columns starting with 'GP' in their names will be used}
}
\value{
Returns a data.frame with original glycan values substituted by normalized ones
}
\description{
Returns glycans normalized with Total Area Normalization approach.
}
\examples{
exampleData <- data.frame(ID=1:100, GP1=runif(100),
  GP2=rexp(100,0.2), GP3=rgamma(100, 3),
  Plate=factor(sample(1:2,100,replace=TRUE)))
print(head(tanorm(exampleData)))
}
\author{
Ivo Ugrina
}

