% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compositionsCompatibility.R,
%   R/gstatCompatibility.R
\name{as.LMCAnisCompo}
\alias{as.LMCAnisCompo}
\alias{gstat2LMCAnisCompo}
\alias{as.LMCAnisCompo.LMCAnisCompo}
\alias{as.LMCAnisCompo.gmCgram}
\alias{as.LMCAnisCompo.CompLinModCoReg}
\alias{as.LMCAnisCompo.gstat}
\alias{as.LMCAnisCompo.variogramModelList}
\title{Recast compositional variogram model to format LMCAnisCompo}
\usage{
as.LMCAnisCompo(m, ...)

\method{as.LMCAnisCompo}{LMCAnisCompo}(m, ...)

\method{as.LMCAnisCompo}{gmCgram}(m, V = NULL, orignames = rownames(V), ...)

\method{as.LMCAnisCompo}{CompLinModCoReg}(m, varnames, ...)

\method{as.LMCAnisCompo}{gstat}(m, ...)

\method{as.LMCAnisCompo}{variogramModelList}(m, V = NULL, orignames = NULL, ...)
}
\arguments{
\item{m}{original variogram model}

\item{...}{arguments for generic functionality}

\item{V}{eventually, a specification of the way \code{m} is presently represented}

\item{orignames}{eventually, vector of names of the components, if \code{V} is provided and it does not have rownnames}

\item{varnames}{a vector with the component names}
}
\value{
the variogram model recasted to class "LMCAnisCompo"
}
\description{
Recast a compositional variogram model of any sort to a variation-variogram model of class
"LMCAnisCompo".
}
\section{Methods (by class)}{
\itemize{
\item \code{LMCAnisCompo}: Recast compositional variogram model to format LMCAnisCompo

\item \code{gmCgram}: Recast compositional variogram model to format LMCAnisCompo

\item \code{CompLinModCoReg}: Recast a variogram model from package "compositions" to format LMCAnisCompo

\item \code{gstat}: Recast compositional variogram model to format LMCAnisCompo

\item \code{variogramModelList}: Recast compositional variogram model to format LMCAnisCompo
}}

