% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_var.R
\name{add_var}
\alias{add_var}
\title{Add variables to a Gaussian mixture model}
\usage{
add_var(gmm, var)
}
\arguments{
\item{gmm}{An object of class \code{gmm}. If \code{NULL}, a \code{gmm} object
is created with the added variables and one mixture component.}

\item{var}{A character vector containing the added variables, or a data frame
or numeric matrix whose columns are named after the added variables. In the
first case, for each mixture component, the marginal mean vector of the added
variables is 0 and the marginal covariance matrix the identity matrix. In the
second case, these mean vector and covariance matrix are computed from the
data (after removing the rows that contain missing values).}
}
\value{
The \code{gmm} object after adding the variables.
}
\description{
This function adds variables to a Gaussian mixture model.
}
\examples{
data(gmm_body, data_body)
gmm_1 <- add_var(gmm_body, "GENDER")
gmm_2 <- add_var(gmm_body, data_body[, "GENDER"])

}
\seealso{
\code{\link{remove_var}}, \code{\link{rename_var}}
}
