% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predictMethod.R
\name{predict.gmvar}
\alias{predict.gmvar}
\title{Predict method for class 'gmvar' objects}
\usage{
\method{predict}{gmvar}(
  object,
  ...,
  n_ahead,
  n_simu = 2000,
  pi = c(0.95, 0.8),
  pi_type = c("two-sided", "upper", "lower", "none"),
  pred_type = c("median", "mean", "cond_mean"),
  plot_res = TRUE,
  mix_weights = TRUE,
  nt
)
}
\arguments{
\item{object}{an object of class \code{'gmvar'}, generated by function \code{fitGMVAR} or \code{GMVAR}.}

\item{...}{additional arguments passed to \code{grid} (ignored if \code{plot_res==FALSE}) which plots
grid to the figure.}

\item{n_ahead}{how many steps ahead should be predicted?}

\item{n_simu}{to how many independent simulations should the forecast be based on?}

\item{pi}{a numeric vector specifying the confidence levels of the prediction intervals.}

\item{pi_type}{should the prediction intervals be "two-sided", "upper", or "lower"?}

\item{pred_type}{should the prediction be based on sample "median" or "mean"? Or should it
be one-step-ahead forecast based on the exact conditional mean (\code{"cond_mean"})?
Prediction intervals won't be calculated if the exact conditional mean is used.}

\item{plot_res}{should the results be plotted?}

\item{mix_weights}{\code{TRUE} if forecasts for mixing weights should be plotted,
\code{FALSE} in not.}

\item{nt}{a positive integer specifying the number of observations to be plotted
along with the prediction (ignored if \code{plot_res==FALSE}). Default is \code{round(nrow(data)*0.15)}.}
}
\value{
Returns a class '\code{gmvarpred}' object containing, among the specifications,...
 \describe{
   \item{$pred}{Point forecasts}
   \item{$pred_int}{Prediction intervals, as \code{[, , d]}.}
   \item{$mix_pred}{Point forecasts for the mixing weights}
   \item{mix_pred_int}{Individual prediction intervals for mixing weights, as \code{[, , m]}, m=1,..,M.}
 }
}
\description{
Forecast GMVAR process defined as a class \code{'gmvar'} object. The forecasts are
  computed by performing independent simulations and using the sample medians or means as point
  forecasts and empirical quantiles as prediction intervals. For one-step-ahead predictions
  using the exact conditional mean is also supported.
}
\examples{
\donttest{
## These are long running examples that use parallel computing!

# These examples use the data 'eurusd' which comes with the
# package, but in a scaled form.
data <- cbind(10*eurusd[,1], 100*eurusd[,2])
colnames(data) <- colnames(eurusd)

# GMVAR(2,2) model
fit22 <- fitGMVAR(data, p=2, M=2, ncalls=12, seeds=42:53)
p1 <- predict(fit22, n_ahead=20, pred_type="median")
p1
p2 <- predict(fit22, n_ahead=10, nt=20, lty=1)
p2
p3 <- predict(fit22, n_ahead=10, pi=c(0.99, 0.90, 0.80, 0.70),
              nt=30, lty=0)
p3

# GMVAR(1,2) model
fit12 <- fitGMVAR(data, p=1, M=2)
p1 <- predict(fit12, n_ahead=1, pred_type="cond_mean",
              plot_res=FALSE)
p1
p2 <- predict(fit12, n_ahead=10, pred_type="mean")
p2
p3 <- predict(fit12, n_ahead=10, pi_type="upper")
p3
}
}
\references{
\itemize{
   \item Kalliovirta L., Meitz M. and Saikkonen P. 2016. Gaussian mixture vector autoregression.
         \emph{Journal of Econometrics}, \strong{192}, 485-498.
 }
}
