% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/uncondMoments.R
\name{VAR_pcovmat}
\alias{VAR_pcovmat}
\title{Calculate the dp-dimensional covariance matrix of p consecutive
 observations of a VAR process}
\usage{
VAR_pcovmat(p, d, all_Am, Omega_m)
}
\arguments{
\item{p}{a positive integer specifying the autoregressive order of the model.}

\item{d}{the number of time series in the system.}

\item{all_Am}{\code{[d, d, p]} array containing the AR coefficient matrices}

\item{Omega_m}{the dxd error term covariance matrix}
}
\value{
Returns the (dp x dp) covariance matrix.
}
\description{
\code{VAR_pcovmat} calculate the dp-dimensional covariance matrix of p consecutive
 observations of a VAR process with the algorithm proposed by McElroy (2017).
}
\details{
Most of the code in this function is adapted from the one provided in the
 supplementary material of McElroy (2017). Reproduced under GNU General
 Public License, Copyright (2015) Tucker McElroy.
}
\references{
\itemize{
   \item McElroy T. 2017. Computation of vector ARMA autocovariances.
         \emph{Statistics and Probability Letters}, \strong{124}, 92-96.
 }
}
