% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/loglikelihood.R
\name{get_alpha_mt}
\alias{get_alpha_mt}
\title{Get mixing weights alpha_mt (this function is for internal use)}
\usage{
get_alpha_mt(M, log_mvnvalues, alphas, epsilon, conditional, also_l_0 = FALSE)
}
\arguments{
\item{M}{a positive integer specifying the number of mixture components.}

\item{log_mvnvalues}{\eqn{T x M} matrix containing the log multivariate normal densities.}

\item{alphas}{\eqn{M x 1} vector containing the mixing weight pa}

\item{epsilon}{the smallest number such that its exponent is wont classified as numerically zero
(around \code{-698} is used).}

\item{conditional}{a logical argument specifying whether the conditional or exact log-likelihood function
should be used.}

\item{also_l_0}{return also l_0 (the first term in the exact log-likelihood function)?}
}
\value{
Returns the mixing weights a matrix of the same dimension as \code{log_mvnvalues} so
  that the t:th row is for the time point t and m:th column is for the regime m.
}
\description{
\code{get_alpha_mt} computes the mixing weights based on
  the logarithm of the multivariate normal densities in the definition of
  the mixing weights.
}
\details{
Note that we index the time series as \eqn{-p+1,...,0,1,...,T} as in Kalliovirta et al. (2016).
}
\references{
\itemize{
   \item Kalliovirta L., Meitz M. and Saikkonen P. 2016. Gaussian mixture vector autoregression.
         \emph{Journal of Econometrics}, \strong{192}, 485-498.
   \item Virolainen S. 2020. Structural Gaussian mixture vector autoregressive model. Unpublished working
     paper, available as arXiv:2007.04713.
 }
 @keywords internal
}
\seealso{
\code{\link{loglikelihood_int}}
}
\keyword{internal}
