% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/quantileResiduals.R
\name{dlogmultinorm}
\alias{dlogmultinorm}
\title{Calculate logarithms of multiple multivariate normal densities with varying
 mean and constant covariance matrix}
\usage{
dlogmultinorm(y, mu, inv_Omega, log_det_Omega)
}
\arguments{
\item{y}{dimension \eqn{(T x k)} matrix where each row is a k-dimensional vector}

\item{mu}{dimension \eqn{(T x k)} matrix where each row is the mean of the k-dimensional
vector in corresponding row of \code{y}.}

\item{inv_Omega}{inverse of the \eqn{(k x k)} covariance matrix Omega.}

\item{log_det_Omega}{logarithm of the determinant of the covariance matrix Omega.}
}
\value{
Returns a size \eqn{(T x 1)} vector containing the multinormal densities in logarithm.
}
\description{
\code{dlogmultinorm} calculates logarithms of multiple multivariate normal
  densities with varying mean and constant covariance matrix.
}
\keyword{internal}
