% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gmwmx.R
\name{create_A_matrix}
\alias{create_A_matrix}
\title{Define matrix A of the functional model}
\usage{
create_A_matrix(t_nogap, jumps, n_seasonal)
}
\arguments{
\item{t_nogap}{A \code{vector} specifying the index of the time series.}

\item{jumps}{A \code{vector} specifying the time at which there is a mean shift of the time series. Should be specified to \code{NULL} if there is not presence of offsets in the signal.}

\item{n_seasonal}{An \code{integer} specifying the number of sinusoidal signals in the time series.}
}
\value{
Matrix A in order to compute the functional component of the model in a linear fashion
}
\description{
Define matrix A of the functional model
}
\examples{
n= 10*365
jump_vec <- c(200, 300, 500)
nbr_sin = 2
A <- create_A_matrix(1:n, jump_vec, n_seasonal = nbr_sin)
head(A)
A <- create_A_matrix(1:n, jumps = NULL, n_seasonal = nbr_sin)
head(A)
}
