% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gnrprod.R
\name{gnrprod}
\alias{gnrprod}
\title{Estimate production functions and productivity: Gandhi, Navarro, and Rivers (2020)}
\usage{
gnrprod(output, fixed, flex, share, in_price = NULL,
               out_price = NULL, id, time, data, B = NULL,
               fs_control = NULL, ss_control = NULL, ...)
}
\arguments{
\item{output}{name (character) of variable of log gross output in data or a numeric vector.}

\item{fixed}{name (character or character vector) of variables of log fixed inputs in data or a numeric matrix.}

\item{flex}{name (character) of variable of log flexible input in data or a numeric vector.}

\item{share}{name (character) of variable of log intermediate input's revenue share in data or a numeric vector.}

\item{in_price}{optional (required if \code{share} is not specified) name (character) of variable of common flexible input price or a numeric vector.}

\item{out_price}{optional (required if \code{share} is not specified) name (character) of variable of common output price or a numeric vector.}

\item{id}{name (character) of variable of firm ID in data or a numeric vector.}

\item{time}{name (character) of variable of time in data or a numeric vector.}

\item{data}{\code{\link[base]{data.frame}} containing all variables with names specified by arguments above (left empty if arguments above are vector/matrix rather than strings).}

\item{B}{number of bootstrap repetitions to retrieve standard errors of elasticity estimates. By default, \code{gnrprod} does not bootstrap, i.e., \code{B = NULL}. Setting \code{B > 1} will output bootstrapped standard errors.}

\item{fs_control}{an optional list of convergence settings of the first stage. See \code{\link[gnrprod]{gnrflex.control}} for listing.}

\item{ss_control}{an optional list of convergence settings of the second stage. See \code{\link[gnrprod]{gnriv.control}} for listing.}

\item{...}{additional optional arguments to be passed to \code{\link[stats]{optim}} in the second stage.}
}
\value{
a list of class 'gnr' with five elements:

\code{estimates}: a list with two elements: \code{elas} the parameter estimates and \code{std_errors} the standard errors.

\code{data}: a \code{\link[base]{data.frame}} containing: \code{output}, \code{fixed}, \code{flex}, \code{share}, \code{id}, \code{time}, estimated elasticities for each observation, estimated productivity, and first stage residuals.

\code{first_stage}: a list containing five elements describing the share regression (first stage):
\itemize{
\item{\code{coefficients}}{: a numeric vector of the coefficients of the first stage estimator scaled by a constant. See Gandhi, Navarro, and Rivers (2020, p. 1994, equation (21)).}
\item{\code{SSR}}{: sum of squared residual.}
\item{\code{iterations}}{: number of iterations performed.}
\item{\code{convergence}}{: boolean indicating whether convergence was achieved.}
\item{\code{control}}{: list of convergence control parameters (see \code{\link[gnrprod]{gnrflex.control}}).}
}

\code{second_stage}: a list containing four elements describing the second stage:
\itemize{
\item{\code{optim_method}}{: the method for optimization. Defaults to 'BFGS'. See \code{\link[stats]{optim}} for a listing of available methods.}
\item{\code{optim_info}}{: the returned list of the \code{\link[stats]{optim}} function estimating the coefficients of the constant of integration. See Gandhi, Navarro, and Rivers (2020, p. 1994, equation (21)).}
\item{\code{optim_control}}{: the list of control parameters passed to \code{\link[stats]{optim}}.}
\item{\code{degree}}{: degree of Markov process for persistent productivity.}
}

\code{call}: the function call.
}
\description{
The \code{gnrprod} function is the front end of the
\code{gnrprod} package. It estimates production functions and productivity
in two stages: \code{\link[gnrprod]{gnrflex}} (estimate flexible input elasticity) and
\code{\link[gnrprod]{gnriv}} (estimate fixed input elasticities and productivity).
If the production-related inputs are characters, a \code{\link[base]{data.frame}}
must be specified under \code{data}. Alternatively, matrices/vectors may be
directly specified without specifying \code{data}. \code{gnrprod} currently
supports only one flexible input.
}
\examples{
require(gnrprod)
data <- colombian
industry_311 <- gnrprod(output = "RGO", fixed = c("L", "K"),
                        flex = "RI", share = "share", id = "id",
                        time = "year", data = data,
                        fs_control = list(degree = 2, maxit = 200),
                        ss_control = list(trace = 1))
                        
}
\references{
Gandhi, Amit, Salvador Navarro, and David Rivers. 2020. "On the Identification of Gross Output Production Functions." \emph{Journal of Political Economy}, 128(8): 2973-3016. \doi{10.1086/707736}.
}
