% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gnriv.control.R
\name{gnriv.control}
\alias{gnriv.control}
\title{Control parameters in \code{gnriv}}
\usage{
gnriv.control(degree_w = -1, degree_tau = 3, method = "BFGS", ...)
}
\arguments{
\item{degree_w}{degree of Markov process for persistent productivity. Defaults to 3.}

\item{degree_tau}{degree of expansion for constant of integration. Defaults to the degree of first stage.}

\item{method}{the method of optimization passed to \code{\link[stats]{optim}}. Defaults to "BFGS." See \code{\link[stats]{optim}} under 'Details' for listing of available methods.}

\item{...}{additional optional control parameters passed to \code{\link[stats]{optim}}. See \code{\link[stats]{optim}} for available parameters.}
}
\value{
a list containing \code{degree} and \code{method} and any additional parameters in \code{...}.
}
\description{
Allows the user to modify convergence parameters of Gauss Newton algorithm used in the \code{\link[gnrprod]{gnriv}} function
}
