% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fitEquiv.R
\name{fitEquiv}
\alias{fitEquiv}
\title{Fit Equivalent}
\usage{
fitEquiv(measured_value, dof, pct = 0.95, ndecimals = 2, fitmetric = R2,
  trend = NULL, ...)
}
\arguments{
\item{measured_value}{a real number}

\item{dof}{an integer}

\item{pct}{a real number between 0 and 1}

\item{ndecimals}{an integer}

\item{fitmetric}{a character string naming a standard fit metric (R2, rmse, or user-defined function)}

\item{trend}{a character string "Increasing", "Decreasing", "Flat", "Uncertain" which describes the general slope of the fitmetric function.}

\item{...}{any argument that functions within this routine might use}
}
\value{
a real number
}
\description{
Rescales the fit value to distance to the threshold
}
\examples{
fitEquiv(0.8, 6)
fitEquiv(0.1, dof=8, fitmetric=rmse)

}

