% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rsquared.R
\name{Rsquared}
\alias{Rsquared}
\title{R-squared for Categorical Response Models}
\usage{
Rsquared(model, measure)
}
\arguments{
\item{model}{single model object for which R2 is determined.}

\item{measure}{selects any of the different measures available.}
}
\value{
\item{measure}{the name of the R-squared calculated.}

\item{R2}{realized value of the computed R2.}

\item{adj}{adjusted R2, only available when McFadden's R2 is computed.}

\item{sqrt.R2}{Modified R2 with a square root penalty, only available when
the Ugba & Gertheiss's R2 is computed.}

\item{log.R2}{Modified R2 with a logarithmic penalty, only available when
the Ugba & Gertheiss's is computed.}
}
\description{
computes the summary measures of predictive strength (i.e., pseudo-R2s)
of several categorical outcome models.
}
\details{
\code{Rsquared} provides different R2 indices for both binary and
multi-categorical response models. Supported classes include: \code{glm},
\code{vglm}, \code{clm}, \code{polr}, \code{multinom}, \code{mlogit},
\code{serp}. In other words, mainly models with binary or multi-categorical
outcomes are supported. The non-likelihood based measures, including the Mckelvey,
Tjur and Efron R2s are only available for binary models, while the rest of the
measures (likelihood-based) are all available for both binary and
multi-categorical models. The Ugba & Gertheiss's R2 in particular, computes
the recently proposed modification of the popular Mcfadden's R2. The likelihood
ratio index in the said R2 is penalized using either a square-root or logarithmic
stabilizing function of the response category. The two approaches yield practically
the same result.
}
\examples{
require(serp)

pom <- serp(ordered(RET) ~ DIAB + GH + BP, link="logit",
            slope = "parallel", reverse = TRUE, data = retinopathy)
Rsquared(pom, measure = "mcfadden")
Rsquared(pom, measure = "ugba")

}
\references{
Long, J.S. (1997). \emph{Regression Models for Categorical and Limited
    Dependent Variables}. California: Sage Publications.

Ugba, E. R. and Gertheiss, J. (2018). An Augmented Likelihood Ratio Index
for Categorical Response Models. In \emph{Proceedings of 33rd International
Workshop on Statistical Modelling}, Bristol, 293-298.
}
\seealso{
\code{\link{erroR}}
}
