% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filter_management.R
\name{ga_filter_add}
\alias{ga_filter_add}
\title{Create a new filter and add it to the view (optional).}
\usage{
ga_filter_add(Filter, accountId, webPropertyId = NULL, viewId = NULL,
  linkFilter = FALSE)
}
\arguments{
\item{Filter}{The Filter object to be added to the account or view.  See examples.}

\item{accountId}{Account Id of the account to add the Filter to}

\item{webPropertyId}{Property Id of the property to add the Filter to}

\item{viewId}{View Id of the view to add the Filter to}

\item{linkFilter}{If TRUE will apply the Filter to the view. Needs propetyId and viewId to be set.}
}
\value{
The filterId created if \code{linkFilter=FALSE} or a Filter object if \code{linkFilter=TRUE}
}
\description{
Take a filter object and add and/or apply it so its live.
}
\details{
If you don't set \code{linkFilter=TRUE} then the filter will only be created but not applied.  
You will find it listed in the admin panel Account > All Filters.  You can then use \link{ga_filter_apply_to_view} to apply later on.
}
\examples{

\dontrun{
## Create a filter object for adding an IP exclusion:
Filter <- list(
               name = 'Exclude Internal Traffic',
               type = 'EXCLUDE',
               excludeDetails = list(
                   field = 'GEO_IP_ADDRESS',
                   matchType = 'EQUAL',
                   expressionValue = '199.04.123.1',
                   caseSensitive = 'False'
                                    )
              )

# create and add the filter to the view specified      
my_filter <- ga_filter_add(Filter, 
                           accountId = 12345, 
                           webPropertyId = "UA-12345-1", 
                           viewId = 654321,
                           linkFilter = TRUE)

# only create the filter, don't apply it to any view - returns filterId for use later
my_filter <- ga_filter_add(Filter, 
                           accountId = 12345, 
                           linkFilter = FALSE)                          

## Other examples of filters you can create below:
## Create a filter object for making campaign medium lowercase
Filter <- list(
               name = 'Lowercase Campaign Medium',
               type = 'LOWERCASE',
               lowercaseDetails = list(
                   field = 'CAMPAIGN_MEDIUM'
                                    )
              )

## Create a filter object to append hostname to URI
Filter <- list(
               name = 'Append hostname to URI',
               type = 'ADVANCED',
               advancedDetails = list(
                   fieldA = 'PAGE_HOSTNAME',
                   extractA = '(.*)',
                   fieldARequired = 'True',
                   fieldB = 'PAGE_REQUEST_URI',
                   extractB = '(.*)',
                   fieldBRequired = 'False',
                   outputConstructor = '$A1$B1',
                   outputToField = 'PAGE_REQUEST_URI',
                   caseSensitive = 'False',
                   overrideOutputField = 'True'
                                    )
              )

## Create a filter object to add www hostname without it
Filter <- list(
               name = 'Search and Replace www',
               type = 'SEARCH_AND_REPLACE',
               searchAndReplaceDetails = list(
                   field = 'PAGE_HOSTNAME',
                   searchString = '^exampleUSA\\\\.com$',
                   replaceString = 'www.exampleUSA.com',
                   caseSensitive = 'False'
                                    )
              )

}

}
\seealso{
\url{https://developers.google.com/analytics/devguides/config/mgmt/v3/mgmtReference/#Filters}

Other managementAPI functions: \code{\link{ga_accounts}},
  \code{\link{ga_adwords_list}}, \code{\link{ga_adwords}},
  \code{\link{ga_custom_vars_list}},
  \code{\link{ga_custom_vars}},
  \code{\link{ga_experiment_list}},
  \code{\link{ga_experiment}},
  \code{\link{ga_filter_apply_to_view}},
  \code{\link{ga_filter_delete}},
  \code{\link{ga_filter_list}},
  \code{\link{ga_filter_update_filter_link}},
  \code{\link{ga_filter_update}},
  \code{\link{ga_filter_view_list}},
  \code{\link{ga_filter_view}}, \code{\link{ga_filter}},
  \code{\link{ga_goal_list}}, \code{\link{ga_goal}},
  \code{\link{ga_remarketing_estimate}},
  \code{\link{ga_remarketing_get}},
  \code{\link{ga_remarketing_list}},
  \code{\link{ga_segment_list}},
  \code{\link{ga_unsampled_list}},
  \code{\link{ga_unsampled}}, \code{\link{ga_users_list}},
  \code{\link{ga_view_list}}, \code{\link{ga_view}},
  \code{\link{ga_webproperty_list}},
  \code{\link{ga_webproperty}},
  \code{\link{google_analytics_account_list}}
}
